@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAccountAlias.
 * @property accountAlias Alias associated with the AWS account.
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetAccountAliasResult(
    public val accountAlias: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetAccountAliasResult):
            GetAccountAliasResult = GetAccountAliasResult(
            accountAlias = javaType.accountAlias(),
            id = javaType.id(),
        )
    }
}
