@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getOpenIdConnectProvider.
 * @property arn
 * @property clientIdLists List of client IDs (also known as audiences). When a mobile or web app registers with an OpenID Connect provider, they establish a value that identifies the application. (This is the value that's sent as the client_id parameter on OAuth requests.)
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Map of resource tags for the IAM OIDC provider.
 * @property thumbprintLists List of server certificate thumbprints for the OpenID Connect (OIDC) identity provider's server certificate(s).
 * @property url
 */
public data class GetOpenIdConnectProviderResult(
    public val arn: String,
    public val clientIdLists: List<String>,
    public val id: String,
    public val tags: Map<String, String>,
    public val thumbprintLists: List<String>,
    public val url: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetOpenIdConnectProviderResult):
            GetOpenIdConnectProviderResult = GetOpenIdConnectProviderResult(
            arn = javaType.arn(),
            clientIdLists = javaType.clientIdLists().map({ args0 -> args0 }),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            thumbprintLists = javaType.thumbprintLists().map({ args0 -> args0 }),
            url = javaType.url(),
        )
    }
}
