@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actions List of actions that this statement either allows or denies. For example, `["ec2:RunInstances", "s3:*"]`.
 * @property conditions Configuration block for a condition. Detailed below.
 * @property effect Whether this statement allows or denies the given actions. Valid values are `Allow` and `Deny`. Defaults to `Allow`.
 * @property notActions List of actions that this statement does *not* apply to. Use to apply a policy statement to all actions *except* those listed.
 * @property notPrincipals Like `principals` except these are principals that the statement does *not* apply to.
 * @property notResources List of resource ARNs that this statement does *not* apply to. Use to apply a policy statement to all resources *except* those listed. Conflicts with `resources`.
 * @property principals Configuration block for principals. Detailed below.
 * @property resources List of resource ARNs that this statement applies to. This is required by AWS if used for an IAM policy. Conflicts with `not_resources`.
 * @property sid Sid (statement ID) is an identifier for a policy statement.
 */
public data class GetPolicyDocumentStatement(
    public val actions: List<String>? = null,
    public val conditions: List<GetPolicyDocumentStatementCondition>? = null,
    public val effect: String? = null,
    public val notActions: List<String>? = null,
    public val notPrincipals: List<GetPolicyDocumentStatementNotPrincipal>? = null,
    public val notResources: List<String>? = null,
    public val principals: List<GetPolicyDocumentStatementPrincipal>? = null,
    public val resources: List<String>? = null,
    public val sid: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPolicyDocumentStatement):
            GetPolicyDocumentStatement = GetPolicyDocumentStatement(
            actions = javaType.actions().map({ args0 -> args0 }),
            conditions = javaType.conditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentStatementCondition.Companion.toKotlin(args0)
                })
            }),
            effect = javaType.effect().map({ args0 -> args0 }).orElse(null),
            notActions = javaType.notActions().map({ args0 -> args0 }),
            notPrincipals = javaType.notPrincipals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentStatementNotPrincipal.Companion.toKotlin(args0)
                })
            }),
            notResources = javaType.notResources().map({ args0 -> args0 }),
            principals = javaType.principals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPolicyDocumentStatementPrincipal.Companion.toKotlin(args0)
                })
            }),
            resources = javaType.resources().map({ args0 -> args0 }),
            sid = javaType.sid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
