@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property test Name of the [IAM condition operator](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html) to evaluate.
 * @property values Values to evaluate the condition against. If multiple values are provided, the condition matches if at least one of them applies. That is, AWS evaluates multiple values as though using an "OR" boolean operation.
 * @property variable Name of a [Context Variable](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements.html#AvailableKeys) to apply the condition to. Context variables may either be standard AWS variables starting with `aws:` or service-specific variables prefixed with the service name.
 */
public data class GetPolicyDocumentStatementCondition(
    public val test: String,
    public val values: List<String>,
    public val variable: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPolicyDocumentStatementCondition):
            GetPolicyDocumentStatementCondition = GetPolicyDocumentStatementCondition(
            test = javaType.test(),
            values = javaType.values().map({ args0 -> args0 }),
            variable = javaType.variable(),
        )
    }
}
