@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The context _condition key_ to set.
 * If you have policies containing `Condition` elements or using dynamic interpolations then you will need to provide suitable values for each condition key your policies use. See [Actions, resources, and condition keys for AWS services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html) to find the various condition keys that are normally provided for real requests to each action of each AWS service.
 * @property type An IAM value type that determines how the policy simulator will interpret the strings given in `values`.
 * For more information, see the `ContextKeyType` field of [`iam&#46;ContextEntry`](https://docs.aws.amazon.com/IAM/latest/APIReference/API_ContextEntry.html) in the underlying API.
 * @property values A set of one or more values for this context entry.
 */
public data class GetPrincipalPolicySimulationContext(
    public val key: String,
    public val type: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPrincipalPolicySimulationContext):
            GetPrincipalPolicySimulationContext = GetPrincipalPolicySimulationContext(
            key = javaType.key(),
            type = javaType.type(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
