@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property actionName The name of the single IAM action used for this particular request.
 * @property allowed `true` if `decision` is "allowed", and `false` otherwise.
 * @property decision The raw decision determined from all of the policies in scope; either "allowed", "explicitDeny", or "implicitDeny".
 * @property decisionDetails A map of arbitrary metadata entries returned by the policy simulator for this request.
 * @property matchedStatements A nested set of objects describing which policies contained statements that were relevant to this simulation request. Each object has attributes `source_policy_id` and `source_policy_type` to identify one of the policies.
 * @property missingContextKeys A set of context keys (or condition keys) that were needed by some of the policies contributing to this result but not specified using a `context` block in the configuration. Missing or incorrect context keys will typically cause a simulated request to be disallowed.
 * @property resourceArn ARN of the resource that was used for this particular request. When you specify multiple actions and multiple resource ARNs, that causes a separate policy request for each combination of unique action and resource.
 */
public data class GetPrincipalPolicySimulationResult(
    public val actionName: String,
    public val allowed: Boolean,
    public val decision: String,
    public val decisionDetails: Map<String, String>,
    public val matchedStatements: List<GetPrincipalPolicySimulationResultMatchedStatement>,
    public val missingContextKeys: List<String>,
    public val resourceArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetPrincipalPolicySimulationResult):
            GetPrincipalPolicySimulationResult = GetPrincipalPolicySimulationResult(
            actionName = javaType.actionName(),
            allowed = javaType.allowed(),
            decision = javaType.decision(),
            decisionDetails = javaType.decisionDetails().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            matchedStatements = javaType.matchedStatements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.iam.kotlin.outputs.GetPrincipalPolicySimulationResultMatchedStatement.Companion.toKotlin(args0)
                })
            }),
            missingContextKeys = javaType.missingContextKeys().map({ args0 -> args0 }),
            resourceArn = javaType.resourceArn(),
        )
    }
}
