@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getSamlProvider.
 * @property arn
 * @property createDate Creation date of the SAML provider in RFC1123 format, e.g. `Mon, 02 Jan 2006 15:04:05 MST`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the provider.
 * @property samlMetadataDocument The XML document generated by an identity provider that supports SAML 2.0.
 * @property tags Tags attached to the SAML provider.
 * @property validUntil Expiration date and time for the SAML provider in RFC1123 format, e.g. `Mon, 02 Jan 2007 15:04:05 MST`.
 */
public data class GetSamlProviderResult(
    public val arn: String,
    public val createDate: String,
    public val id: String,
    public val name: String,
    public val samlMetadataDocument: String,
    public val tags: Map<String, String>,
    public val validUntil: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetSamlProviderResult):
            GetSamlProviderResult = GetSamlProviderResult(
            arn = javaType.arn(),
            createDate = javaType.createDate(),
            id = javaType.id(),
            name = javaType.name(),
            samlMetadataDocument = javaType.samlMetadataDocument(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            validUntil = javaType.validUntil(),
        )
    }
}
