@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getServerCertificate.
 * @property arn is set to the ARN of the IAM Server Certificate
 * @property certificateBody is the public key certificate (PEM-encoded). This is useful when [configuring back-end instance authentication](http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html) policy for load balancer
 * @property certificateChain is the public key certificate chain (PEM-encoded) if exists, empty otherwise
 * @property expirationDate is set to the expiration date of the IAM Server Certificate
 * @property id The provider-assigned unique ID for this managed resource.
 * @property latest
 * @property name
 * @property namePrefix
 * @property path is set to the path of the IAM Server Certificate
 * @property pathPrefix
 * @property uploadDate is the date when the server certificate was uploaded
 */
public data class GetServerCertificateResult(
    public val arn: String,
    public val certificateBody: String,
    public val certificateChain: String,
    public val expirationDate: String,
    public val id: String,
    public val latest: Boolean? = null,
    public val name: String,
    public val namePrefix: String? = null,
    public val path: String,
    public val pathPrefix: String? = null,
    public val uploadDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetServerCertificateResult):
            GetServerCertificateResult = GetServerCertificateResult(
            arn = javaType.arn(),
            certificateBody = javaType.certificateBody(),
            certificateChain = javaType.certificateChain(),
            expirationDate = javaType.expirationDate(),
            id = javaType.id(),
            latest = javaType.latest().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            namePrefix = javaType.namePrefix().map({ args0 -> args0 }).orElse(null),
            path = javaType.path(),
            pathPrefix = javaType.pathPrefix().map({ args0 -> args0 }).orElse(null),
            uploadDate = javaType.uploadDate(),
        )
    }
}
