@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getSessionContext.
 * @property arn
 * @property id The provider-assigned unique ID for this managed resource.
 * @property issuerArn IAM source role ARN if `arn` corresponds to an STS assumed role. Otherwise, `issuer_arn` is equal to `arn`.
 * @property issuerId Unique identifier of the IAM role that issues the STS assumed role.
 * @property issuerName Name of the source role. Only available if `arn` corresponds to an STS assumed role.
 * @property sessionName Name of the STS session. Only available if `arn` corresponds to an STS assumed role.
 */
public data class GetSessionContextResult(
    public val arn: String,
    public val id: String,
    public val issuerArn: String,
    public val issuerId: String,
    public val issuerName: String,
    public val sessionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetSessionContextResult):
            GetSessionContextResult = GetSessionContextResult(
            arn = javaType.arn(),
            id = javaType.id(),
            issuerArn = javaType.issuerArn(),
            issuerId = javaType.issuerId(),
            issuerName = javaType.issuerName(),
            sessionName = javaType.sessionName(),
        )
    }
}
