@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getUser.
 * @property arn ARN assigned by AWS for this user.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property path Path in which this user was created.
 * @property permissionsBoundary The ARN of the policy that is used to set the permissions boundary for the user.
 * @property tags Map of key-value pairs associated with the user.
 * @property userId Unique ID assigned by AWS for this user.
 * @property userName Name associated to this User
 */
public data class GetUserResult(
    public val arn: String,
    public val id: String,
    public val path: String,
    public val permissionsBoundary: String,
    public val tags: Map<String, String>,
    public val userId: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.GetUserResult): GetUserResult =
            GetUserResult(
                arn = javaType.arn(),
                id = javaType.id(),
                path = javaType.path(),
                permissionsBoundary = javaType.permissionsBoundary(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                userId = javaType.userId(),
                userName = javaType.userName(),
            )
    }
}
