@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.iam.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the role policy.
 * @property policy Policy document as a JSON formatted string.
 */
public data class RoleInlinePolicy(
    public val name: String? = null,
    public val policy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.iam.outputs.RoleInlinePolicy): RoleInlinePolicy =
            RoleInlinePolicy(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                policy = javaType.policy().map({ args0 -> args0 }).orElse(null),
            )
    }
}
