@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.aws.identitystore.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IdentityStore Group.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import an Identity Store Group using the combination `identity_store_id/group_id`. For example:
 * ```sh
 *  $ pulumi import aws:identitystore/group:Group example d-9c6705e95c/b8a1c340-8031-7071-a2fb-7dc540320c30
 * ```
 * @property description A string containing the description of the group.
 * @property displayName A string containing the name of the group. This value is commonly displayed when the group is referenced.
 * @property identityStoreId The globally unique identifier for the identity store.
 * The following arguments are optional:
 */
public data class GroupArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identityStoreId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.GroupArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.GroupArgs =
        com.pulumi.aws.identitystore.GroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identityStoreId(identityStoreId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identityStoreId: Output<String>? = null

    /**
     * @param value A string containing the description of the group.
     */
    @JvmName("uhfavjmkahwopyos")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A string containing the name of the group. This value is commonly displayed when the group is referenced.
     */
    @JvmName("xnibxlvydpndshjx")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The globally unique identifier for the identity store.
     * The following arguments are optional:
     */
    @JvmName("mkisbvltnhqqoybk")
    public suspend fun identityStoreId(`value`: Output<String>) {
        this.identityStoreId = value
    }

    /**
     * @param value A string containing the description of the group.
     */
    @JvmName("hjoxvgcpknehrpru")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A string containing the name of the group. This value is commonly displayed when the group is referenced.
     */
    @JvmName("pyuanbldahpgdqae")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The globally unique identifier for the identity store.
     * The following arguments are optional:
     */
    @JvmName("copqqrdornvcxeva")
    public suspend fun identityStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityStoreId = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        description = description,
        displayName = displayName,
        identityStoreId = identityStoreId,
    )
}
