@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupMembership].
 */
@PulumiTagMarker
public class GroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMembershipArgs = GroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMembershipArgsBuilder.() -> Unit) {
        val builder = GroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GroupMembership {
        val builtJavaResource = com.pulumi.aws.identitystore.GroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMembership(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS IdentityStore Group Membership.
 * ## Import
 * Using `pulumi import`, import `aws_identitystore_group_membership` using the `identity_store_id/membership_id`. For example:
 * ```sh
 *  $ pulumi import aws:identitystore/groupMembership:GroupMembership example d-0000000000/00000000-0000-0000-0000-000000000000
 * ```
 *
 */
public class GroupMembership internal constructor(
    override val javaResource: com.pulumi.aws.identitystore.GroupMembership,
) : KotlinCustomResource(javaResource, GroupMembershipMapper) {
    /**
     * The identifier for a group in the Identity Store.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * Identity Store ID associated with the Single Sign-On Instance.
     */
    public val identityStoreId: Output<String>
        get() = javaResource.identityStoreId().applyValue({ args0 -> args0 })

    /**
     * The identifier for a user in the Identity Store.
     */
    public val memberId: Output<String>
        get() = javaResource.memberId().applyValue({ args0 -> args0 })

    /**
     * The identifier of the newly created group membership in the Identity Store.
     */
    public val membershipId: Output<String>
        get() = javaResource.membershipId().applyValue({ args0 -> args0 })
}

public object GroupMembershipMapper : ResourceMapper<GroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.identitystore.GroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): GroupMembership = GroupMembership(
        javaResource as
            com.pulumi.aws.identitystore.GroupMembership,
    )
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMembership].
 */
public suspend fun groupMembership(
    name: String,
    block: suspend GroupMembershipResourceBuilder.() -> Unit,
): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMembership(name: String): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
