@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.aws.identitystore.GroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS IdentityStore Group Membership.
 * ## Import
 * Using `pulumi import`, import `aws_identitystore_group_membership` using the `identity_store_id/membership_id`. For example:
 * ```sh
 *  $ pulumi import aws:identitystore/groupMembership:GroupMembership example d-0000000000/00000000-0000-0000-0000-000000000000
 * ```
 * @property groupId The identifier for a group in the Identity Store.
 * @property identityStoreId Identity Store ID associated with the Single Sign-On Instance.
 * @property memberId The identifier for a user in the Identity Store.
 */
public data class GroupMembershipArgs(
    public val groupId: Output<String>? = null,
    public val identityStoreId: Output<String>? = null,
    public val memberId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.GroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.GroupMembershipArgs =
        com.pulumi.aws.identitystore.GroupMembershipArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .identityStoreId(identityStoreId?.applyValue({ args0 -> args0 }))
            .memberId(memberId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMembershipArgs].
 */
@PulumiTagMarker
public class GroupMembershipArgsBuilder internal constructor() {
    private var groupId: Output<String>? = null

    private var identityStoreId: Output<String>? = null

    private var memberId: Output<String>? = null

    /**
     * @param value The identifier for a group in the Identity Store.
     */
    @JvmName("gbebkaypmruarhna")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Identity Store ID associated with the Single Sign-On Instance.
     */
    @JvmName("mutnnaeqwtmrnapu")
    public suspend fun identityStoreId(`value`: Output<String>) {
        this.identityStoreId = value
    }

    /**
     * @param value The identifier for a user in the Identity Store.
     */
    @JvmName("avxedmryosyojrjt")
    public suspend fun memberId(`value`: Output<String>) {
        this.memberId = value
    }

    /**
     * @param value The identifier for a group in the Identity Store.
     */
    @JvmName("jgwbrkvfdroisypx")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Identity Store ID associated with the Single Sign-On Instance.
     */
    @JvmName("yjwwtvngsnvuaput")
    public suspend fun identityStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityStoreId = mapped
    }

    /**
     * @param value The identifier for a user in the Identity Store.
     */
    @JvmName("ejnpxrtwtrjjuhiu")
    public suspend fun memberId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberId = mapped
    }

    internal fun build(): GroupMembershipArgs = GroupMembershipArgs(
        groupId = groupId,
        identityStoreId = identityStoreId,
        memberId = memberId,
    )
}
