@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin

import com.pulumi.aws.identitystore.IdentitystoreFunctions.getGroupPlain
import com.pulumi.aws.identitystore.IdentitystoreFunctions.getUserPlain
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupAlternateIdentifier
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupFilter
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.aws.identitystore.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserAlternateIdentifier
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserFilter
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.identitystore.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.identitystore.kotlin.outputs.GetGroupResult
import com.pulumi.aws.identitystore.kotlin.outputs.GetUserResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.identitystore.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.aws.identitystore.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin

public object IdentitystoreFunctions {
    /**
     * Use this data source to get an Identity Store Group.
     * @param argument A collection of arguments for invoking getGroup.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param alternateIdentifier A unique identifier for the group that is not the primary identifier. Conflicts with `group_id` and `filter`. Detailed below.
     * @param filter Configuration block for filtering by a unique attribute of the group. Detailed below.
     * @param groupId The identifier for a group in the Identity Store.
     * > Exactly one of the above arguments must be provided. Passing both `filter` and `group_id` is allowed for backwards compatibility.
     * @param identityStoreId Identity Store ID associated with the Single Sign-On Instance.
     * The following arguments are optional:
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(
        alternateIdentifier: GetGroupAlternateIdentifier? = null,
        filter: GetGroupFilter? = null,
        groupId: String? = null,
        identityStoreId: String,
    ): GetGroupResult {
        val argument = GetGroupPlainArgs(
            alternateIdentifier = alternateIdentifier,
            filter = filter,
            groupId = groupId,
            identityStoreId = identityStoreId,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;identitystore&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit):
        GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get an Identity Store User.
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param alternateIdentifier A unique identifier for a user or group that is not the primary identifier. Conflicts with `user_id` and `filter`. Detailed below.
     * @param filter Configuration block for filtering by a unique attribute of the user. Detailed below.
     * @param identityStoreId Identity Store ID associated with the Single Sign-On Instance.
     * The following arguments are optional:
     * @param userId The identifier for a user in the Identity Store.
     * > Exactly one of the above arguments must be provided. Passing both `filter` and `user_id` is allowed for backwards compatibility.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(
        alternateIdentifier: GetUserAlternateIdentifier? = null,
        filter: GetUserFilter? = null,
        identityStoreId: String,
        userId: String? = null,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            alternateIdentifier = alternateIdentifier,
            filter = filter,
            identityStoreId = identityStoreId,
            userId = userId,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;identitystore&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }
}
