@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifier.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property externalId Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
 * @property uniqueAttribute An entity attribute that's unique to a specific entity. Detailed below.
 * > Exactly one of the above arguments must be provided.
 */
public data class GetGroupAlternateIdentifier(
    public val externalId: GetGroupAlternateIdentifierExternalId? = null,
    public val uniqueAttribute: GetGroupAlternateIdentifierUniqueAttribute? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifier> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifier =
        com.pulumi.aws.identitystore.inputs.GetGroupAlternateIdentifier.builder()
            .externalId(externalId?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uniqueAttribute(uniqueAttribute?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GetGroupAlternateIdentifier].
 */
@PulumiTagMarker
public class GetGroupAlternateIdentifierBuilder internal constructor() {
    private var externalId: GetGroupAlternateIdentifierExternalId? = null

    private var uniqueAttribute: GetGroupAlternateIdentifierUniqueAttribute? = null

    /**
     * @param value Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
     */
    @JvmName("synnfvnqeqosegco")
    public suspend fun externalId(`value`: GetGroupAlternateIdentifierExternalId?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.externalId = mapped
    }

    /**
     * @param argument Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
     */
    @JvmName("kyydjmhrvorovols")
    public suspend
    fun externalId(argument: suspend GetGroupAlternateIdentifierExternalIdBuilder.() -> Unit) {
        val toBeMapped = GetGroupAlternateIdentifierExternalIdBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.externalId = mapped
    }

    /**
     * @param value An entity attribute that's unique to a specific entity. Detailed below.
     * > Exactly one of the above arguments must be provided.
     */
    @JvmName("msosgovsiumlyltb")
    public suspend fun uniqueAttribute(`value`: GetGroupAlternateIdentifierUniqueAttribute?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.uniqueAttribute = mapped
    }

    /**
     * @param argument An entity attribute that's unique to a specific entity. Detailed below.
     * > Exactly one of the above arguments must be provided.
     */
    @JvmName("htcnckvtxrwhmiph")
    public suspend
    fun uniqueAttribute(argument: suspend GetGroupAlternateIdentifierUniqueAttributeBuilder.() -> Unit) {
        val toBeMapped = GetGroupAlternateIdentifierUniqueAttributeBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.uniqueAttribute = mapped
    }

    internal fun build(): GetGroupAlternateIdentifier = GetGroupAlternateIdentifier(
        externalId = externalId,
        uniqueAttribute = uniqueAttribute,
    )
}
