@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.UserEmailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property primary When `true`, this is the primary email associated with the user.
 * @property type The type of email.
 * @property value The email address. This value must be unique across the identity store.
 */
public data class UserEmailsArgs(
    public val primary: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.UserEmailsArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.UserEmailsArgs =
        com.pulumi.aws.identitystore.inputs.UserEmailsArgs.builder()
            .primary(primary?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserEmailsArgs].
 */
@PulumiTagMarker
public class UserEmailsArgsBuilder internal constructor() {
    private var primary: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value When `true`, this is the primary email associated with the user.
     */
    @JvmName("olesdlcjbnjetudo")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value The type of email.
     */
    @JvmName("sxriemhqnhtfedxy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The email address. This value must be unique across the identity store.
     */
    @JvmName("isfqtdgdiodmqepj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value When `true`, this is the primary email associated with the user.
     */
    @JvmName("oywjgyglvjbtlaxh")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The type of email.
     */
    @JvmName("yokpifnyawxlfxks")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The email address. This value must be unique across the identity store.
     */
    @JvmName("ecpiwhrdubwpxbmt")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): UserEmailsArgs = UserEmailsArgs(
        primary = primary,
        type = type,
        `value` = `value`,
    )
}
