@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.inputs

import com.pulumi.aws.identitystore.inputs.UserPhoneNumbersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property primary When `true`, this is the primary phone number associated with the user.
 * @property type The type of phone number.
 * @property value The user's phone number.
 */
public data class UserPhoneNumbersArgs(
    public val primary: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.identitystore.inputs.UserPhoneNumbersArgs> {
    override fun toJava(): com.pulumi.aws.identitystore.inputs.UserPhoneNumbersArgs =
        com.pulumi.aws.identitystore.inputs.UserPhoneNumbersArgs.builder()
            .primary(primary?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPhoneNumbersArgs].
 */
@PulumiTagMarker
public class UserPhoneNumbersArgsBuilder internal constructor() {
    private var primary: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value When `true`, this is the primary phone number associated with the user.
     */
    @JvmName("owyvrkyogodpvhne")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value The type of phone number.
     */
    @JvmName("jsihynycbiqplpfq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The user's phone number.
     */
    @JvmName("btniacswnaeurhrs")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value When `true`, this is the primary phone number associated with the user.
     */
    @JvmName("awfivloirybowdxd")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value The type of phone number.
     */
    @JvmName("lqlhvobdwjmrajpl")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user's phone number.
     */
    @JvmName("ieunkraydclipvly")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): UserPhoneNumbersArgs = UserPhoneNumbersArgs(
        primary = primary,
        type = type,
        `value` = `value`,
    )
}
