@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property externalId Configuration block for filtering by the identifier issued by an external identity provider. Detailed below.
 * @property uniqueAttribute An entity attribute that's unique to a specific entity. Detailed below.
 * > Exactly one of the above arguments must be provided.
 */
public data class GetGroupAlternateIdentifier(
    public val externalId: GetGroupAlternateIdentifierExternalId? = null,
    public val uniqueAttribute: GetGroupAlternateIdentifierUniqueAttribute? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupAlternateIdentifier):
            GetGroupAlternateIdentifier = GetGroupAlternateIdentifier(
            externalId = javaType.externalId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupAlternateIdentifierExternalId.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uniqueAttribute = javaType.uniqueAttribute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupAlternateIdentifierUniqueAttribute.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
