@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributePath Attribute path that is used to specify which attribute name to search. For example: `DisplayName`. Refer to the [Group data type](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html).
 * @property attributeValue Value for an attribute.
 */
public data class GetGroupAlternateIdentifierUniqueAttribute(
    public val attributePath: String,
    public val attributeValue: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupAlternateIdentifierUniqueAttribute):
            GetGroupAlternateIdentifierUniqueAttribute = GetGroupAlternateIdentifierUniqueAttribute(
            attributePath = javaType.attributePath(),
            attributeValue = javaType.attributeValue(),
        )
    }
}
