@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroup.
 * @property alternateIdentifier
 * @property description Description of the specified group.
 * @property displayName Group's display name value.
 * @property externalIds List of identifiers issued to this resource by an external identity provider.
 * @property filter
 * @property groupId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityStoreId
 */
public data class GetGroupResult(
    public val alternateIdentifier: GetGroupAlternateIdentifier? = null,
    public val description: String,
    public val displayName: String,
    public val externalIds: List<GetGroupExternalId>,
    @Deprecated(
        message = """
  Use the alternate_identifier attribute instead.
  """,
    )
    public val filter: GetGroupFilter? = null,
    public val groupId: String,
    public val id: String,
    public val identityStoreId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetGroupResult):
            GetGroupResult = GetGroupResult(
            alternateIdentifier = javaType.alternateIdentifier().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupAlternateIdentifier.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            displayName = javaType.displayName(),
            externalIds = javaType.externalIds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupExternalId.Companion.toKotlin(args0)
                })
            }),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.identitystore.kotlin.outputs.GetGroupFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            groupId = javaType.groupId(),
            id = javaType.id(),
            identityStoreId = javaType.identityStoreId(),
        )
    }
}
