@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property country The country that this address is in.
 * @property formatted The name that is typically displayed when the name is shown for display.
 * @property locality The address locality.
 * @property postalCode The postal code of the address.
 * @property primary When `true`, this is the primary phone number associated with the user.
 * @property region The region of the address.
 * @property streetAddress The street of the address.
 * @property type The type of phone number.
 */
public data class GetUserAddress(
    public val country: String,
    public val formatted: String,
    public val locality: String,
    public val postalCode: String,
    public val primary: Boolean,
    public val region: String,
    public val streetAddress: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.GetUserAddress):
            GetUserAddress = GetUserAddress(
            country = javaType.country(),
            formatted = javaType.formatted(),
            locality = javaType.locality(),
            postalCode = javaType.postalCode(),
            primary = javaType.primary(),
            region = javaType.region(),
            streetAddress = javaType.streetAddress(),
            type = javaType.type(),
        )
    }
}
