@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property country The country that this address is in.
 * @property formatted The name that is typically displayed when the address is shown for display.
 * @property locality The address locality.
 * @property postalCode The postal code of the address.
 * @property primary When `true`, this is the primary address associated with the user.
 * @property region The region of the address.
 * @property streetAddress The street of the address.
 * @property type The type of address.
 */
public data class UserAddresses(
    public val country: String? = null,
    public val formatted: String? = null,
    public val locality: String? = null,
    public val postalCode: String? = null,
    public val primary: Boolean? = null,
    public val region: String? = null,
    public val streetAddress: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.UserAddresses): UserAddresses =
            UserAddresses(
                country = javaType.country().map({ args0 -> args0 }).orElse(null),
                formatted = javaType.formatted().map({ args0 -> args0 }).orElse(null),
                locality = javaType.locality().map({ args0 -> args0 }).orElse(null),
                postalCode = javaType.postalCode().map({ args0 -> args0 }).orElse(null),
                primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
                region = javaType.region().map({ args0 -> args0 }).orElse(null),
                streetAddress = javaType.streetAddress().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
