@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property primary When `true`, this is the primary email associated with the user.
 * @property type The type of email.
 * @property value The email address. This value must be unique across the identity store.
 */
public data class UserEmails(
    public val primary: Boolean? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.UserEmails): UserEmails =
            UserEmails(
                primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
