@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.identitystore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property familyName The family name of the user.
 * @property formatted The name that is typically displayed when the name is shown for display.
 * @property givenName The given name of the user.
 * The following arguments are optional:
 * @property honorificPrefix The honorific prefix of the user.
 * @property honorificSuffix The honorific suffix of the user.
 * @property middleName The middle name of the user.
 */
public data class UserName(
    public val familyName: String,
    public val formatted: String? = null,
    public val givenName: String,
    public val honorificPrefix: String? = null,
    public val honorificSuffix: String? = null,
    public val middleName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.identitystore.outputs.UserName): UserName =
            UserName(
                familyName = javaType.familyName(),
                formatted = javaType.formatted().map({ args0 -> args0 }).orElse(null),
                givenName = javaType.givenName(),
                honorificPrefix = javaType.honorificPrefix().map({ args0 -> args0 }).orElse(null),
                honorificSuffix = javaType.honorificSuffix().map({ args0 -> args0 }).orElse(null),
                middleName = javaType.middleName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
