@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeComponent
import com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeInstanceConfiguration
import com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeTargetRepository
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeComponent.Companion.toKotlin as containerRecipeComponentToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeInstanceConfiguration.Companion.toKotlin as containerRecipeInstanceConfigurationToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ContainerRecipeTargetRepository.Companion.toKotlin as containerRecipeTargetRepositoryToKotlin

/**
 * Builder for [ContainerRecipe].
 */
@PulumiTagMarker
public class ContainerRecipeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerRecipeArgs = ContainerRecipeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerRecipeArgsBuilder.() -> Unit) {
        val builder = ContainerRecipeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContainerRecipe {
        val builtJavaResource = com.pulumi.aws.imagebuilder.ContainerRecipe(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContainerRecipe(builtJavaResource)
    }
}

/**
 * Manages an Image Builder Container Recipe.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ContainerRecipe;
 * import com.pulumi.aws.imagebuilder.ContainerRecipeArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContainerRecipe("example", ContainerRecipeArgs.builder()
 *             .version("1.0.0")
 *             .containerType("DOCKER")
 *             .parentImage("arn:aws:imagebuilder:eu-central-1:aws:image/amazon-linux-x86-latest/x.x.x")
 *             .targetRepository(ContainerRecipeTargetRepositoryArgs.builder()
 *                 .repositoryName(aws_ecr_repository.example().name())
 *                 .service("ECR")
 *                 .build())
 *             .components(ContainerRecipeComponentArgs.builder()
 *                 .componentArn(aws_imagebuilder_component.example().arn())
 *                 .parameters(
 *                     ContainerRecipeComponentParameterArgs.builder()
 *                         .name("Parameter1")
 *                         .value("Value1")
 *                         .build(),
 *                     ContainerRecipeComponentParameterArgs.builder()
 *                         .name("Parameter2")
 *                         .value("Value2")
 *                         .build())
 *                 .build())
 *             .dockerfileTemplateData("""
 * FROM {{{ imagebuilder:parentImage }}}
 * {{{ imagebuilder:environments }}}
 * {{{ imagebuilder:components }}}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_container_recipe` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/containerRecipe:ContainerRecipe example arn:aws:imagebuilder:us-east-1:123456789012:container-recipe/example/1.0.0
 * ```
 *
 */
public class ContainerRecipe internal constructor(
    override val javaResource: com.pulumi.aws.imagebuilder.ContainerRecipe,
) : KotlinCustomResource(javaResource, ContainerRecipeMapper) {
    /**
     * (Required) Amazon Resource Name (ARN) of the container recipe.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    public val components: Output<List<ContainerRecipeComponent>>
        get() = javaResource.components().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerRecipeComponentToKotlin(args0)
                })
            })
        })

    /**
     * The type of the container to create. Valid values: `DOCKER`.
     */
    public val containerType: Output<String>
        get() = javaResource.containerType().applyValue({ args0 -> args0 })

    /**
     * Date the container recipe was created.
     */
    public val dateCreated: Output<String>
        get() = javaResource.dateCreated().applyValue({ args0 -> args0 })

    /**
     * The description of the container recipe.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Dockerfile template used to build the image as an inline data blob.
     */
    public val dockerfileTemplateData: Output<String>
        get() = javaResource.dockerfileTemplateData().applyValue({ args0 -> args0 })

    /**
     * The Amazon S3 URI for the Dockerfile that will be used to build the container image.
     */
    public val dockerfileTemplateUri: Output<String>?
        get() = javaResource.dockerfileTemplateUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
     */
    public val encrypted: Output<Boolean>
        get() = javaResource.encrypted().applyValue({ args0 -> args0 })

    /**
     * Configuration block used to configure an instance for building and testing container images. Detailed below.
     */
    public val instanceConfiguration: Output<ContainerRecipeInstanceConfiguration>?
        get() = javaResource.instanceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> containerRecipeInstanceConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The KMS key used to encrypt the container image.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the container recipe.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Owner of the container recipe.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * The base image for the container recipe.
     */
    public val parentImage: Output<String>
        get() = javaResource.parentImage().applyValue({ args0 -> args0 })

    /**
     * Platform of the container recipe.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Specifies the operating system platform when you use a custom base image.
     */
    public val platformOverride: Output<String>?
        get() = javaResource.platformOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The destination repository for the container image. Detailed below.
     */
    public val targetRepository: Output<ContainerRecipeTargetRepository>
        get() = javaResource.targetRepository().applyValue({ args0 ->
            args0.let({ args0 ->
                containerRecipeTargetRepositoryToKotlin(args0)
            })
        })

    /**
     * Version of the container recipe.
     * The following attributes are optional:
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The working directory to be used during build and test workflows.
     */
    public val workingDirectory: Output<String>?
        get() = javaResource.workingDirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ContainerRecipeMapper : ResourceMapper<ContainerRecipe> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.imagebuilder.ContainerRecipe::class == javaResource::class

    override fun map(javaResource: Resource): ContainerRecipe = ContainerRecipe(
        javaResource as
            com.pulumi.aws.imagebuilder.ContainerRecipe,
    )
}

/**
 * @see [ContainerRecipe].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerRecipe].
 */
public suspend fun containerRecipe(
    name: String,
    block: suspend ContainerRecipeResourceBuilder.() -> Unit,
): ContainerRecipe {
    val builder = ContainerRecipeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerRecipe].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerRecipe(name: String): ContainerRecipe {
    val builder = ContainerRecipeResourceBuilder()
    builder.name(name)
    return builder.build()
}
