@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ContainerRecipeArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ContainerRecipeComponentArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ContainerRecipeComponentArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ContainerRecipeInstanceConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ContainerRecipeInstanceConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ContainerRecipeTargetRepositoryArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ContainerRecipeTargetRepositoryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Container Recipe.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ContainerRecipe;
 * import com.pulumi.aws.imagebuilder.ContainerRecipeArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContainerRecipe("example", ContainerRecipeArgs.builder()
 *             .version("1.0.0")
 *             .containerType("DOCKER")
 *             .parentImage("arn:aws:imagebuilder:eu-central-1:aws:image/amazon-linux-x86-latest/x.x.x")
 *             .targetRepository(ContainerRecipeTargetRepositoryArgs.builder()
 *                 .repositoryName(aws_ecr_repository.example().name())
 *                 .service("ECR")
 *                 .build())
 *             .components(ContainerRecipeComponentArgs.builder()
 *                 .componentArn(aws_imagebuilder_component.example().arn())
 *                 .parameters(
 *                     ContainerRecipeComponentParameterArgs.builder()
 *                         .name("Parameter1")
 *                         .value("Value1")
 *                         .build(),
 *                     ContainerRecipeComponentParameterArgs.builder()
 *                         .name("Parameter2")
 *                         .value("Value2")
 *                         .build())
 *                 .build())
 *             .dockerfileTemplateData("""
 * FROM {{{ imagebuilder:parentImage }}}
 * {{{ imagebuilder:environments }}}
 * {{{ imagebuilder:components }}}
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_container_recipe` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/containerRecipe:ContainerRecipe example arn:aws:imagebuilder:us-east-1:123456789012:container-recipe/example/1.0.0
 * ```
 * @property components Ordered configuration block(s) with components for the container recipe. Detailed below.
 * @property containerType The type of the container to create. Valid values: `DOCKER`.
 * @property description The description of the container recipe.
 * @property dockerfileTemplateData The Dockerfile template used to build the image as an inline data blob.
 * @property dockerfileTemplateUri The Amazon S3 URI for the Dockerfile that will be used to build the container image.
 * @property instanceConfiguration Configuration block used to configure an instance for building and testing container images. Detailed below.
 * @property kmsKeyId The KMS key used to encrypt the container image.
 * @property name The name of the container recipe.
 * @property parentImage The base image for the container recipe.
 * @property platformOverride Specifies the operating system platform when you use a custom base image.
 * @property tags Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetRepository The destination repository for the container image. Detailed below.
 * @property version Version of the container recipe.
 * The following attributes are optional:
 * @property workingDirectory The working directory to be used during build and test workflows.
 */
public data class ContainerRecipeArgs(
    public val components: Output<List<ContainerRecipeComponentArgs>>? = null,
    public val containerType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dockerfileTemplateData: Output<String>? = null,
    public val dockerfileTemplateUri: Output<String>? = null,
    public val instanceConfiguration: Output<ContainerRecipeInstanceConfigurationArgs>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentImage: Output<String>? = null,
    public val platformOverride: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetRepository: Output<ContainerRecipeTargetRepositoryArgs>? = null,
    public val version: Output<String>? = null,
    public val workingDirectory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ContainerRecipeArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ContainerRecipeArgs =
        com.pulumi.aws.imagebuilder.ContainerRecipeArgs.builder()
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .containerType(containerType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dockerfileTemplateData(dockerfileTemplateData?.applyValue({ args0 -> args0 }))
            .dockerfileTemplateUri(dockerfileTemplateUri?.applyValue({ args0 -> args0 }))
            .instanceConfiguration(
                instanceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentImage(parentImage?.applyValue({ args0 -> args0 }))
            .platformOverride(platformOverride?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetRepository(targetRepository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workingDirectory(workingDirectory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRecipeArgs].
 */
@PulumiTagMarker
public class ContainerRecipeArgsBuilder internal constructor() {
    private var components: Output<List<ContainerRecipeComponentArgs>>? = null

    private var containerType: Output<String>? = null

    private var description: Output<String>? = null

    private var dockerfileTemplateData: Output<String>? = null

    private var dockerfileTemplateUri: Output<String>? = null

    private var instanceConfiguration: Output<ContainerRecipeInstanceConfigurationArgs>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var parentImage: Output<String>? = null

    private var platformOverride: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetRepository: Output<ContainerRecipeTargetRepositoryArgs>? = null

    private var version: Output<String>? = null

    private var workingDirectory: Output<String>? = null

    /**
     * @param value Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("tjapcputcdniehdy")
    public suspend fun components(`value`: Output<List<ContainerRecipeComponentArgs>>) {
        this.components = value
    }

    @JvmName("tiybrctfuxckosvc")
    public suspend fun components(vararg values: Output<ContainerRecipeComponentArgs>) {
        this.components = Output.all(values.asList())
    }

    /**
     * @param values Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("ljvpufekskmsiowe")
    public suspend fun components(values: List<Output<ContainerRecipeComponentArgs>>) {
        this.components = Output.all(values)
    }

    /**
     * @param value The type of the container to create. Valid values: `DOCKER`.
     */
    @JvmName("iybbmdhvrwluopbd")
    public suspend fun containerType(`value`: Output<String>) {
        this.containerType = value
    }

    /**
     * @param value The description of the container recipe.
     */
    @JvmName("mtwoacyisqiahqxe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Dockerfile template used to build the image as an inline data blob.
     */
    @JvmName("pnqsicloanntivjs")
    public suspend fun dockerfileTemplateData(`value`: Output<String>) {
        this.dockerfileTemplateData = value
    }

    /**
     * @param value The Amazon S3 URI for the Dockerfile that will be used to build the container image.
     */
    @JvmName("tdrkfdtpjdbiuxjm")
    public suspend fun dockerfileTemplateUri(`value`: Output<String>) {
        this.dockerfileTemplateUri = value
    }

    /**
     * @param value Configuration block used to configure an instance for building and testing container images. Detailed below.
     */
    @JvmName("rmettnqluvnjvdkd")
    public suspend
    fun instanceConfiguration(`value`: Output<ContainerRecipeInstanceConfigurationArgs>) {
        this.instanceConfiguration = value
    }

    /**
     * @param value The KMS key used to encrypt the container image.
     */
    @JvmName("anigyelbhgqyujja")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of the container recipe.
     */
    @JvmName("arjnbhmkrwnoymyw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The base image for the container recipe.
     */
    @JvmName("rsgwusakqylwfvcu")
    public suspend fun parentImage(`value`: Output<String>) {
        this.parentImage = value
    }

    /**
     * @param value Specifies the operating system platform when you use a custom base image.
     */
    @JvmName("rhdrxquqyawhebqm")
    public suspend fun platformOverride(`value`: Output<String>) {
        this.platformOverride = value
    }

    /**
     * @param value Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gsaqwkeatpswmdbk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The destination repository for the container image. Detailed below.
     */
    @JvmName("vnjfgvcgifspiysl")
    public suspend fun targetRepository(`value`: Output<ContainerRecipeTargetRepositoryArgs>) {
        this.targetRepository = value
    }

    /**
     * @param value Version of the container recipe.
     * The following attributes are optional:
     */
    @JvmName("bnbgbahncoktaqkw")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The working directory to be used during build and test workflows.
     */
    @JvmName("dffcyfjyhnbjytpg")
    public suspend fun workingDirectory(`value`: Output<String>) {
        this.workingDirectory = value
    }

    /**
     * @param value Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("fqqmjxdomcoabaqp")
    public suspend fun components(`value`: List<ContainerRecipeComponentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param argument Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("qvhxdtotveoytbjr")
    public suspend
    fun components(argument: List<suspend ContainerRecipeComponentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerRecipeComponentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("eeyvjeimkqwtaljb")
    public suspend fun components(
        vararg
        argument: suspend ContainerRecipeComponentArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerRecipeComponentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("qeqylhionuyjxkwv")
    public suspend fun components(argument: suspend ContainerRecipeComponentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerRecipeComponentArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param values Ordered configuration block(s) with components for the container recipe. Detailed below.
     */
    @JvmName("hshnsexcxamyngqt")
    public suspend fun components(vararg values: ContainerRecipeComponentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value The type of the container to create. Valid values: `DOCKER`.
     */
    @JvmName("lfecbhnasxdtdxur")
    public suspend fun containerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerType = mapped
    }

    /**
     * @param value The description of the container recipe.
     */
    @JvmName("ltnqswgpkubwwkyi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Dockerfile template used to build the image as an inline data blob.
     */
    @JvmName("ueglvlygbfmwlaio")
    public suspend fun dockerfileTemplateData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfileTemplateData = mapped
    }

    /**
     * @param value The Amazon S3 URI for the Dockerfile that will be used to build the container image.
     */
    @JvmName("jcqwvctmhwslcicg")
    public suspend fun dockerfileTemplateUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerfileTemplateUri = mapped
    }

    /**
     * @param value Configuration block used to configure an instance for building and testing container images. Detailed below.
     */
    @JvmName("dykkfkeprtlmkuei")
    public suspend fun instanceConfiguration(`value`: ContainerRecipeInstanceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceConfiguration = mapped
    }

    /**
     * @param argument Configuration block used to configure an instance for building and testing container images. Detailed below.
     */
    @JvmName("spovljcqjbjccdhr")
    public suspend
    fun instanceConfiguration(argument: suspend ContainerRecipeInstanceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRecipeInstanceConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceConfiguration = mapped
    }

    /**
     * @param value The KMS key used to encrypt the container image.
     */
    @JvmName("dxcowdymyqxbvgco")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of the container recipe.
     */
    @JvmName("kogsoltrqhlrodqi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The base image for the container recipe.
     */
    @JvmName("rqtblhkfvhjiwpsh")
    public suspend fun parentImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentImage = mapped
    }

    /**
     * @param value Specifies the operating system platform when you use a custom base image.
     */
    @JvmName("nwgicerhugwglcyt")
    public suspend fun platformOverride(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformOverride = mapped
    }

    /**
     * @param value Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wnxovhagruhehecl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the container recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qvvqrcuwadlcbbst")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The destination repository for the container image. Detailed below.
     */
    @JvmName("ricfbysoayyhmmgo")
    public suspend fun targetRepository(`value`: ContainerRecipeTargetRepositoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRepository = mapped
    }

    /**
     * @param argument The destination repository for the container image. Detailed below.
     */
    @JvmName("fnegmqftnmerlogg")
    public suspend
    fun targetRepository(argument: suspend ContainerRecipeTargetRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerRecipeTargetRepositoryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.targetRepository = mapped
    }

    /**
     * @param value Version of the container recipe.
     * The following attributes are optional:
     */
    @JvmName("svaudimyjtvbmanq")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The working directory to be used during build and test workflows.
     */
    @JvmName("acydlhrnvwigymsa")
    public suspend fun workingDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDirectory = mapped
    }

    internal fun build(): ContainerRecipeArgs = ContainerRecipeArgs(
        components = components,
        containerType = containerType,
        description = description,
        dockerfileTemplateData = dockerfileTemplateData,
        dockerfileTemplateUri = dockerfileTemplateUri,
        instanceConfiguration = instanceConfiguration,
        kmsKeyId = kmsKeyId,
        name = name,
        parentImage = parentImage,
        platformOverride = platformOverride,
        tags = tags,
        targetRepository = targetRepository,
        version = version,
        workingDirectory = workingDirectory,
    )
}
