@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistribution
import com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistribution.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DistributionConfiguration].
 */
@PulumiTagMarker
public class DistributionConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DistributionConfigurationArgs = DistributionConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DistributionConfigurationArgsBuilder.() -> Unit) {
        val builder = DistributionConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DistributionConfiguration {
        val builtJavaResource =
            com.pulumi.aws.imagebuilder.DistributionConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DistributionConfiguration(builtJavaResource)
    }
}

/**
 * Manages an Image Builder Distribution Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.DistributionConfiguration;
 * import com.pulumi.aws.imagebuilder.DistributionConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DistributionConfiguration("example", DistributionConfigurationArgs.builder()
 *             .distributions(DistributionConfigurationDistributionArgs.builder()
 *                 .amiDistributionConfiguration(DistributionConfigurationDistributionAmiDistributionConfigurationArgs.builder()
 *                     .amiTags(Map.of("CostCenter", "IT"))
 *                     .launchPermission(DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs.builder()
 *                         .userIds("123456789012")
 *                         .build())
 *                     .name("example-{{ imagebuilder:buildDate }}")
 *                     .build())
 *                 .launchTemplateConfigurations(DistributionConfigurationDistributionLaunchTemplateConfigurationArgs.builder()
 *                     .launchTemplateId("lt-0aaa1bcde2ff3456")
 *                     .build())
 *                 .region("us-east-1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_distribution_configurations` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/distributionConfiguration:DistributionConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:distribution-configuration/example
 * ```
 *
 */
public class DistributionConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.imagebuilder.DistributionConfiguration,
) : KotlinCustomResource(javaResource, DistributionConfigurationMapper) {
    /**
     * (Required) Amazon Resource Name (ARN) of the distribution configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date the distribution configuration was created.
     */
    public val dateCreated: Output<String>
        get() = javaResource.dateCreated().applyValue({ args0 -> args0 })

    /**
     * Date the distribution configuration was updated.
     */
    public val dateUpdated: Output<String>
        get() = javaResource.dateUpdated().applyValue({ args0 -> args0 })

    /**
     * Description of the distribution configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    public val distributions: Output<List<DistributionConfigurationDistribution>>
        get() = javaResource.distributions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Name of the distribution configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DistributionConfigurationMapper : ResourceMapper<DistributionConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.imagebuilder.DistributionConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): DistributionConfiguration =
        DistributionConfiguration(
            javaResource as
                com.pulumi.aws.imagebuilder.DistributionConfiguration,
        )
}

/**
 * @see [DistributionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DistributionConfiguration].
 */
public suspend fun distributionConfiguration(
    name: String,
    block: suspend DistributionConfigurationResourceBuilder.() -> Unit,
): DistributionConfiguration {
    val builder = DistributionConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DistributionConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun distributionConfiguration(name: String): DistributionConfiguration {
    val builder = DistributionConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
