@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.DistributionConfigurationArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.DistributionConfigurationDistributionArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.DistributionConfigurationDistributionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Distribution Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.DistributionConfiguration;
 * import com.pulumi.aws.imagebuilder.DistributionConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DistributionConfiguration("example", DistributionConfigurationArgs.builder()
 *             .distributions(DistributionConfigurationDistributionArgs.builder()
 *                 .amiDistributionConfiguration(DistributionConfigurationDistributionAmiDistributionConfigurationArgs.builder()
 *                     .amiTags(Map.of("CostCenter", "IT"))
 *                     .launchPermission(DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs.builder()
 *                         .userIds("123456789012")
 *                         .build())
 *                     .name("example-{{ imagebuilder:buildDate }}")
 *                     .build())
 *                 .launchTemplateConfigurations(DistributionConfigurationDistributionLaunchTemplateConfigurationArgs.builder()
 *                     .launchTemplateId("lt-0aaa1bcde2ff3456")
 *                     .build())
 *                 .region("us-east-1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_distribution_configurations` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/distributionConfiguration:DistributionConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:distribution-configuration/example
 * ```
 * @property description Description of the distribution configuration.
 * @property distributions One or more configuration blocks with distribution settings. Detailed below.
 * The following arguments are optional:
 * @property name Name of the distribution configuration.
 * @property tags Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DistributionConfigurationArgs(
    public val description: Output<String>? = null,
    public val distributions: Output<List<DistributionConfigurationDistributionArgs>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.DistributionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.DistributionConfigurationArgs =
        com.pulumi.aws.imagebuilder.DistributionConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .distributions(
                distributions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DistributionConfigurationArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var distributions: Output<List<DistributionConfigurationDistributionArgs>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the distribution configuration.
     */
    @JvmName("ckdxusjmugtwpbpy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("cjmygrdhafnsmmgq")
    public suspend
    fun distributions(`value`: Output<List<DistributionConfigurationDistributionArgs>>) {
        this.distributions = value
    }

    @JvmName("csvkkjqfyhdanvvp")
    public suspend fun distributions(
        vararg
        values: Output<DistributionConfigurationDistributionArgs>,
    ) {
        this.distributions = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("aaykolhrtrusfrxh")
    public suspend
    fun distributions(values: List<Output<DistributionConfigurationDistributionArgs>>) {
        this.distributions = Output.all(values)
    }

    /**
     * @param value Name of the distribution configuration.
     */
    @JvmName("etwbyxjnvweojeno")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wlyewoagnmiflbff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the distribution configuration.
     */
    @JvmName("nollwxpypmldomol")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("wqobauqhqfivrivl")
    public suspend fun distributions(`value`: List<DistributionConfigurationDistributionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributions = mapped
    }

    /**
     * @param argument One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("fxborkbwnkjpecbq")
    public suspend
    fun distributions(argument: List<suspend DistributionConfigurationDistributionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.distributions = mapped
    }

    /**
     * @param argument One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("tyjlacmywkvvepoj")
    public suspend fun distributions(
        vararg
        argument: suspend DistributionConfigurationDistributionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.distributions = mapped
    }

    /**
     * @param argument One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("wbcnmvoebgtblnci")
    public suspend
    fun distributions(argument: suspend DistributionConfigurationDistributionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DistributionConfigurationDistributionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.distributions = mapped
    }

    /**
     * @param values One or more configuration blocks with distribution settings. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("qvqwhkefxsxmneyq")
    public suspend fun distributions(vararg values: DistributionConfigurationDistributionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distributions = mapped
    }

    /**
     * @param value Name of the distribution configuration.
     */
    @JvmName("vqckuypmgwhtbuuf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vtibiwemdfgfoiry")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the distribution configuration. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("osuqtrhrwdnopdci")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DistributionConfigurationArgs = DistributionConfigurationArgs(
        description = description,
        distributions = distributions,
        name = name,
        tags = tags,
    )
}
