@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ImageArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageScanningConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageScanningConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageTestsConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageImageTestsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Image.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.Image;
 * import com.pulumi.aws.imagebuilder.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Image("example", ImageArgs.builder()
 *             .distributionConfigurationArn(aws_imagebuilder_distribution_configuration.example().arn())
 *             .imageRecipeArn(aws_imagebuilder_image_recipe.example().arn())
 *             .infrastructureConfigurationArn(aws_imagebuilder_infrastructure_configuration.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/image:Image example arn:aws:imagebuilder:us-east-1:123456789012:image/example/1.0.0/1
 * ```
 * @property containerRecipeArn Amazon Resource Name (ARN) of the container recipe.
 * @property distributionConfigurationArn Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
 * @property enhancedImageMetadataEnabled Whether additional information about the image being created is collected. Defaults to `true`.
 * @property imageRecipeArn Amazon Resource Name (ARN) of the image recipe.
 * @property imageScanningConfiguration Configuration block with image scanning configuration. Detailed below.
 * @property imageTestsConfiguration Configuration block with image tests configuration. Detailed below.
 * @property infrastructureConfigurationArn Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ImageArgs(
    public val containerRecipeArn: Output<String>? = null,
    public val distributionConfigurationArn: Output<String>? = null,
    public val enhancedImageMetadataEnabled: Output<Boolean>? = null,
    public val imageRecipeArn: Output<String>? = null,
    public val imageScanningConfiguration: Output<ImageImageScanningConfigurationArgs>? = null,
    public val imageTestsConfiguration: Output<ImageImageTestsConfigurationArgs>? = null,
    public val infrastructureConfigurationArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ImageArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ImageArgs =
        com.pulumi.aws.imagebuilder.ImageArgs.builder()
            .containerRecipeArn(containerRecipeArn?.applyValue({ args0 -> args0 }))
            .distributionConfigurationArn(distributionConfigurationArn?.applyValue({ args0 -> args0 }))
            .enhancedImageMetadataEnabled(enhancedImageMetadataEnabled?.applyValue({ args0 -> args0 }))
            .imageRecipeArn(imageRecipeArn?.applyValue({ args0 -> args0 }))
            .imageScanningConfiguration(
                imageScanningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageTestsConfiguration(
                imageTestsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .infrastructureConfigurationArn(infrastructureConfigurationArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var containerRecipeArn: Output<String>? = null

    private var distributionConfigurationArn: Output<String>? = null

    private var enhancedImageMetadataEnabled: Output<Boolean>? = null

    private var imageRecipeArn: Output<String>? = null

    private var imageScanningConfiguration: Output<ImageImageScanningConfigurationArgs>? = null

    private var imageTestsConfiguration: Output<ImageImageTestsConfigurationArgs>? = null

    private var infrastructureConfigurationArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("gycalwwqbxrlncik")
    public suspend fun containerRecipeArn(`value`: Output<String>) {
        this.containerRecipeArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("dtdvijsmctmomrwp")
    public suspend fun distributionConfigurationArn(`value`: Output<String>) {
        this.distributionConfigurationArn = value
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("lpfrrauglbcxelmq")
    public suspend fun enhancedImageMetadataEnabled(`value`: Output<Boolean>) {
        this.enhancedImageMetadataEnabled = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("igmppdckufqevcjm")
    public suspend fun imageRecipeArn(`value`: Output<String>) {
        this.imageRecipeArn = value
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("ofytpfeavfidpahy")
    public suspend
    fun imageScanningConfiguration(`value`: Output<ImageImageScanningConfigurationArgs>) {
        this.imageScanningConfiguration = value
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("pohowfakyymsijpx")
    public suspend fun imageTestsConfiguration(`value`: Output<ImageImageTestsConfigurationArgs>) {
        this.imageTestsConfiguration = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     * The following arguments are optional:
     */
    @JvmName("yxoadlywmoryubky")
    public suspend fun infrastructureConfigurationArn(`value`: Output<String>) {
        this.infrastructureConfigurationArn = value
    }

    /**
     * @param value Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xqriwnywrbekmmim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("dpnufkpwnhdwmqyg")
    public suspend fun containerRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRecipeArn = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("axwrcrtyyvbklwat")
    public suspend fun distributionConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionConfigurationArn = mapped
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("jpurqmkgbnusxevr")
    public suspend fun enhancedImageMetadataEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedImageMetadataEnabled = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("ntrduvrfurxoyllx")
    public suspend fun imageRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRecipeArn = mapped
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("xjccquapjlkkolva")
    public suspend fun imageScanningConfiguration(`value`: ImageImageScanningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("wsgqxmwwbcpycjdv")
    public suspend
    fun imageScanningConfiguration(argument: suspend ImageImageScanningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImageImageScanningConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("hrixhqrxmcwshdiw")
    public suspend fun imageTestsConfiguration(`value`: ImageImageTestsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("mfwfmrfonobhmjmt")
    public suspend
    fun imageTestsConfiguration(argument: suspend ImageImageTestsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImageImageTestsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     * The following arguments are optional:
     */
    @JvmName("jslbjhjwayepklvc")
    public suspend fun infrastructureConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfigurationArn = mapped
    }

    /**
     * @param value Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vrrsigvhgjtnfvgy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the Image Builder Image. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ihlstacpatwknsgd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        containerRecipeArn = containerRecipeArn,
        distributionConfigurationArn = distributionConfigurationArn,
        enhancedImageMetadataEnabled = enhancedImageMetadataEnabled,
        imageRecipeArn = imageRecipeArn,
        imageScanningConfiguration = imageScanningConfiguration,
        imageTestsConfiguration = imageTestsConfiguration,
        infrastructureConfigurationArn = infrastructureConfigurationArn,
        tags = tags,
    )
}
