@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineImageScanningConfiguration
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineImageTestsConfiguration
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineSchedule
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineImageScanningConfiguration.Companion.toKotlin as imagePipelineImageScanningConfigurationToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineImageTestsConfiguration.Companion.toKotlin as imagePipelineImageTestsConfigurationToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.ImagePipelineSchedule.Companion.toKotlin as imagePipelineScheduleToKotlin

/**
 * Builder for [ImagePipeline].
 */
@PulumiTagMarker
public class ImagePipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImagePipelineArgs = ImagePipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImagePipelineArgsBuilder.() -> Unit) {
        val builder = ImagePipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ImagePipeline {
        val builtJavaResource = com.pulumi.aws.imagebuilder.ImagePipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImagePipeline(builtJavaResource)
    }
}

/**
 * Manages an Image Builder Image Pipeline.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ImagePipeline;
 * import com.pulumi.aws.imagebuilder.ImagePipelineArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ImagePipeline("example", ImagePipelineArgs.builder()
 *             .imageRecipeArn(aws_imagebuilder_image_recipe.example().arn())
 *             .infrastructureConfigurationArn(aws_imagebuilder_infrastructure_configuration.example().arn())
 *             .schedule(ImagePipelineScheduleArgs.builder()
 *                 .scheduleExpression("cron(0 0 * * ? *)")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image_pipeline` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/imagePipeline:ImagePipeline example arn:aws:imagebuilder:us-east-1:123456789012:image-pipeline/example
 * ```
 *
 */
public class ImagePipeline internal constructor(
    override val javaResource: com.pulumi.aws.imagebuilder.ImagePipeline,
) : KotlinCustomResource(javaResource, ImagePipelineMapper) {
    /**
     * Amazon Resource Name (ARN) of the image pipeline.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the container recipe.
     */
    public val containerRecipeArn: Output<String>?
        get() = javaResource.containerRecipeArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date the image pipeline was created.
     */
    public val dateCreated: Output<String>
        get() = javaResource.dateCreated().applyValue({ args0 -> args0 })

    /**
     * Date the image pipeline was last run.
     */
    public val dateLastRun: Output<String>
        get() = javaResource.dateLastRun().applyValue({ args0 -> args0 })

    /**
     * Date the image pipeline will run next.
     */
    public val dateNextRun: Output<String>
        get() = javaResource.dateNextRun().applyValue({ args0 -> args0 })

    /**
     * Date the image pipeline was updated.
     */
    public val dateUpdated: Output<String>
        get() = javaResource.dateUpdated().applyValue({ args0 -> args0 })

    /**
     * Description of the image pipeline.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    public val distributionConfigurationArn: Output<String>?
        get() = javaResource.distributionConfigurationArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether additional information about the image being created is collected. Defaults to `true`.
     */
    public val enhancedImageMetadataEnabled: Output<Boolean>?
        get() = javaResource.enhancedImageMetadataEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the image recipe.
     */
    public val imageRecipeArn: Output<String>?
        get() = javaResource.imageRecipeArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block with image scanning configuration. Detailed below.
     */
    public val imageScanningConfiguration: Output<ImagePipelineImageScanningConfiguration>
        get() = javaResource.imageScanningConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                imagePipelineImageScanningConfigurationToKotlin(args0)
            })
        })

    /**
     * Configuration block with image tests configuration. Detailed below.
     */
    public val imageTestsConfiguration: Output<ImagePipelineImageTestsConfiguration>
        get() = javaResource.imageTestsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                imagePipelineImageTestsConfigurationToKotlin(args0)
            })
        })

    /**
     * Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     */
    public val infrastructureConfigurationArn: Output<String>
        get() = javaResource.infrastructureConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * Name of the image pipeline.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Platform of the image pipeline.
     */
    public val platform: Output<String>
        get() = javaResource.platform().applyValue({ args0 -> args0 })

    /**
     * Configuration block with schedule settings. Detailed below.
     */
    public val schedule: Output<ImagePipelineSchedule>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    imagePipelineScheduleToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ImagePipelineMapper : ResourceMapper<ImagePipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.imagebuilder.ImagePipeline::class == javaResource::class

    override fun map(javaResource: Resource): ImagePipeline = ImagePipeline(
        javaResource as
            com.pulumi.aws.imagebuilder.ImagePipeline,
    )
}

/**
 * @see [ImagePipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImagePipeline].
 */
public suspend fun imagePipeline(
    name: String,
    block: suspend ImagePipelineResourceBuilder.() -> Unit,
): ImagePipeline {
    val builder = ImagePipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImagePipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imagePipeline(name: String): ImagePipeline {
    val builder = ImagePipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
