@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ImagePipelineArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageScanningConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageScanningConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageTestsConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageTestsConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineScheduleArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Image Pipeline.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ImagePipeline;
 * import com.pulumi.aws.imagebuilder.ImagePipelineArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ImagePipeline("example", ImagePipelineArgs.builder()
 *             .imageRecipeArn(aws_imagebuilder_image_recipe.example().arn())
 *             .infrastructureConfigurationArn(aws_imagebuilder_infrastructure_configuration.example().arn())
 *             .schedule(ImagePipelineScheduleArgs.builder()
 *                 .scheduleExpression("cron(0 0 * * ? *)")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image_pipeline` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:imagebuilder/imagePipeline:ImagePipeline example arn:aws:imagebuilder:us-east-1:123456789012:image-pipeline/example
 * ```
 * @property containerRecipeArn Amazon Resource Name (ARN) of the container recipe.
 * @property description Description of the image pipeline.
 * @property distributionConfigurationArn Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
 * @property enhancedImageMetadataEnabled Whether additional information about the image being created is collected. Defaults to `true`.
 * @property imageRecipeArn Amazon Resource Name (ARN) of the image recipe.
 * @property imageScanningConfiguration Configuration block with image scanning configuration. Detailed below.
 * @property imageTestsConfiguration Configuration block with image tests configuration. Detailed below.
 * @property infrastructureConfigurationArn Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
 * @property name Name of the image pipeline.
 * The following arguments are optional:
 * @property schedule Configuration block with schedule settings. Detailed below.
 * @property status Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
 * @property tags Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ImagePipelineArgs(
    public val containerRecipeArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val distributionConfigurationArn: Output<String>? = null,
    public val enhancedImageMetadataEnabled: Output<Boolean>? = null,
    public val imageRecipeArn: Output<String>? = null,
    public val imageScanningConfiguration: Output<ImagePipelineImageScanningConfigurationArgs>? =
        null,
    public val imageTestsConfiguration: Output<ImagePipelineImageTestsConfigurationArgs>? = null,
    public val infrastructureConfigurationArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schedule: Output<ImagePipelineScheduleArgs>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ImagePipelineArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ImagePipelineArgs =
        com.pulumi.aws.imagebuilder.ImagePipelineArgs.builder()
            .containerRecipeArn(containerRecipeArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .distributionConfigurationArn(distributionConfigurationArn?.applyValue({ args0 -> args0 }))
            .enhancedImageMetadataEnabled(enhancedImageMetadataEnabled?.applyValue({ args0 -> args0 }))
            .imageRecipeArn(imageRecipeArn?.applyValue({ args0 -> args0 }))
            .imageScanningConfiguration(
                imageScanningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageTestsConfiguration(
                imageTestsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .infrastructureConfigurationArn(infrastructureConfigurationArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ImagePipelineArgs].
 */
@PulumiTagMarker
public class ImagePipelineArgsBuilder internal constructor() {
    private var containerRecipeArn: Output<String>? = null

    private var description: Output<String>? = null

    private var distributionConfigurationArn: Output<String>? = null

    private var enhancedImageMetadataEnabled: Output<Boolean>? = null

    private var imageRecipeArn: Output<String>? = null

    private var imageScanningConfiguration: Output<ImagePipelineImageScanningConfigurationArgs>? =
        null

    private var imageTestsConfiguration: Output<ImagePipelineImageTestsConfigurationArgs>? = null

    private var infrastructureConfigurationArn: Output<String>? = null

    private var name: Output<String>? = null

    private var schedule: Output<ImagePipelineScheduleArgs>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("dxqfgpheyrvxalmk")
    public suspend fun containerRecipeArn(`value`: Output<String>) {
        this.containerRecipeArn = value
    }

    /**
     * @param value Description of the image pipeline.
     */
    @JvmName("gsorebfcinrplcqa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("rtklxfedvqidrufa")
    public suspend fun distributionConfigurationArn(`value`: Output<String>) {
        this.distributionConfigurationArn = value
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("idrqddfxigwjxbbe")
    public suspend fun enhancedImageMetadataEnabled(`value`: Output<Boolean>) {
        this.enhancedImageMetadataEnabled = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("ktartqsqdylkgkko")
    public suspend fun imageRecipeArn(`value`: Output<String>) {
        this.imageRecipeArn = value
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("aomcgahabmpyvxux")
    public suspend
    fun imageScanningConfiguration(`value`: Output<ImagePipelineImageScanningConfigurationArgs>) {
        this.imageScanningConfiguration = value
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("xbipcpxmypmhgxrh")
    public suspend
    fun imageTestsConfiguration(`value`: Output<ImagePipelineImageTestsConfigurationArgs>) {
        this.imageTestsConfiguration = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     */
    @JvmName("potguoclclthvdij")
    public suspend fun infrastructureConfigurationArn(`value`: Output<String>) {
        this.infrastructureConfigurationArn = value
    }

    /**
     * @param value Name of the image pipeline.
     * The following arguments are optional:
     */
    @JvmName("stunusibtkqqxuoc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block with schedule settings. Detailed below.
     */
    @JvmName("thembxsefkunonxm")
    public suspend fun schedule(`value`: Output<ImagePipelineScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
     */
    @JvmName("xtrsdlshukgocnpt")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pyidaqqyevcnenxg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("ifujpxexktuqbgov")
    public suspend fun containerRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRecipeArn = mapped
    }

    /**
     * @param value Description of the image pipeline.
     */
    @JvmName("lbslblgptbppqiqe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("dcakhnhwekhnpxmd")
    public suspend fun distributionConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionConfigurationArn = mapped
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("muowqxulmhxsumgt")
    public suspend fun enhancedImageMetadataEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedImageMetadataEnabled = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("mkpbwfwdjqkngjjg")
    public suspend fun imageRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRecipeArn = mapped
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("dydynanofcigyigq")
    public suspend
    fun imageScanningConfiguration(`value`: ImagePipelineImageScanningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("yhdbkevapjfvxupu")
    public suspend
    fun imageScanningConfiguration(argument: suspend ImagePipelineImageScanningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePipelineImageScanningConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("nxwbhyqawmmmywmy")
    public suspend fun imageTestsConfiguration(`value`: ImagePipelineImageTestsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("wfvvxqsxatnsvurk")
    public suspend
    fun imageTestsConfiguration(argument: suspend ImagePipelineImageTestsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePipelineImageTestsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     */
    @JvmName("ukquyomagouaxsjd")
    public suspend fun infrastructureConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfigurationArn = mapped
    }

    /**
     * @param value Name of the image pipeline.
     * The following arguments are optional:
     */
    @JvmName("kdoidlcspbvrmhvj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block with schedule settings. Detailed below.
     */
    @JvmName("rkckilfkmgxlqcad")
    public suspend fun schedule(`value`: ImagePipelineScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Configuration block with schedule settings. Detailed below.
     */
    @JvmName("xamabbwdhtswnifp")
    public suspend fun schedule(argument: suspend ImagePipelineScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePipelineScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
     */
    @JvmName("gmheooeeoidihfhc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("apncnlhnrocrwuhs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("thvdkmmnqtosjbbp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ImagePipelineArgs = ImagePipelineArgs(
        containerRecipeArn = containerRecipeArn,
        description = description,
        distributionConfigurationArn = distributionConfigurationArn,
        enhancedImageMetadataEnabled = enhancedImageMetadataEnabled,
        imageRecipeArn = imageRecipeArn,
        imageScanningConfiguration = imageScanningConfiguration,
        imageTestsConfiguration = imageTestsConfiguration,
        infrastructureConfigurationArn = infrastructureConfigurationArn,
        name = name,
        schedule = schedule,
        status = status,
        tags = tags,
    )
}
