@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getComponentPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getComponentsPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getContainerRecipePlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getContainerRecipesPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getDistributionConfigurationPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getDistributionConfigurationsPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getImagePipelinePlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getImagePipelinesPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getImagePlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getImageRecipePlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getImageRecipesPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getInfrastructureConfigurationPlain
import com.pulumi.aws.imagebuilder.ImagebuilderFunctions.getInfrastructureConfigurationsPlain
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetComponentPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetComponentPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetComponentsFilter
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetComponentsPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetComponentsPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetContainerRecipePlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetContainerRecipePlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetContainerRecipesFilter
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetContainerRecipesPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetContainerRecipesPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetDistributionConfigurationPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetDistributionConfigurationPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetDistributionConfigurationsFilter
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetDistributionConfigurationsPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetDistributionConfigurationsPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePipelinePlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePipelinePlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePipelinesFilter
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePipelinesPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePipelinesPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImagePlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImageRecipePlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImageRecipePlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImageRecipesFilter
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImageRecipesPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetImageRecipesPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetInfrastructureConfigurationPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetInfrastructureConfigurationPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetInfrastructureConfigurationsFilter
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetInfrastructureConfigurationsPlainArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.GetInfrastructureConfigurationsPlainArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetComponentResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetComponentsResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipesResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationsResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelineResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelinesResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipeResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipesResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationResult
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetComponentResult.Companion.toKotlin as getComponentResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetComponentsResult.Companion.toKotlin as getComponentsResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeResult.Companion.toKotlin as getContainerRecipeResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipesResult.Companion.toKotlin as getContainerRecipesResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationResult.Companion.toKotlin as getDistributionConfigurationResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetDistributionConfigurationsResult.Companion.toKotlin as getDistributionConfigurationsResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelineResult.Companion.toKotlin as getImagePipelineResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelinesResult.Companion.toKotlin as getImagePipelinesResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipeResult.Companion.toKotlin as getImageRecipeResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageRecipesResult.Companion.toKotlin as getImageRecipesResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageResult.Companion.toKotlin as getImageResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationResult.Companion.toKotlin as getInfrastructureConfigurationResultToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationsResult.Companion.toKotlin as getInfrastructureConfigurationsResultToKotlin

public object ImagebuilderFunctions {
    /**
     * Provides details about an Image Builder Component.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetComponentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getComponent(GetComponentArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-west-2:aws:component/amazon-cloudwatch-agent-linux/1.0.0")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getComponent.
     * @return A collection of values returned by getComponent.
     */
    public suspend fun getComponent(argument: GetComponentPlainArgs): GetComponentResult =
        getComponentResultToKotlin(getComponentPlain(argument.toJava()).await())

    /**
     * @see [getComponent].
     * @param arn ARN of the component.
     * @param tags Key-value map of resource tags for the component.
     * @return A collection of values returned by getComponent.
     */
    public suspend fun getComponent(arn: String, tags: Map<String, String>? = null):
        GetComponentResult {
        val argument = GetComponentPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getComponentResultToKotlin(getComponentPlain(argument.toJava()).await())
    }

    /**
     * @see [getComponent].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetComponentPlainArgs].
     * @return A collection of values returned by getComponent.
     */
    public suspend fun getComponent(argument: suspend GetComponentPlainArgsBuilder.() -> Unit):
        GetComponentResult {
        val builder = GetComponentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentResultToKotlin(getComponentPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Image Builder Components matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetComponentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getComponents(GetComponentsArgs.builder()
     *             .filters(GetComponentsFilterArgs.builder()
     *                 .name("platform")
     *                 .values("Linux")
     *                 .build())
     *             .owner("Self")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getComponents.
     * @return A collection of values returned by getComponents.
     */
    public suspend fun getComponents(argument: GetComponentsPlainArgs): GetComponentsResult =
        getComponentsResultToKotlin(getComponentsPlain(argument.toJava()).await())

    /**
     * @see [getComponents].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param owner Owner of the image recipes. Valid values are `Self`, `Shared` and `Amazon`. Defaults to `Self`.
     * @return A collection of values returned by getComponents.
     */
    public suspend fun getComponents(
        filters: List<GetComponentsFilter>? = null,
        owner: String? =
            null,
    ): GetComponentsResult {
        val argument = GetComponentsPlainArgs(
            filters = filters,
            owner = owner,
        )
        return getComponentsResultToKotlin(getComponentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getComponents].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetComponentsPlainArgs].
     * @return A collection of values returned by getComponents.
     */
    public suspend fun getComponents(argument: suspend GetComponentsPlainArgsBuilder.() -> Unit):
        GetComponentsResult {
        val builder = GetComponentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentsResultToKotlin(getComponentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Image builder Container Recipe.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetContainerRecipeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getContainerRecipe(GetContainerRecipeArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-east-1:aws:container-recipe/example/1.0.0")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getContainerRecipe.
     * @return A collection of values returned by getContainerRecipe.
     */
    public suspend fun getContainerRecipe(argument: GetContainerRecipePlainArgs):
        GetContainerRecipeResult =
        getContainerRecipeResultToKotlin(getContainerRecipePlain(argument.toJava()).await())

    /**
     * @see [getContainerRecipe].
     * @param arn ARN of the container recipe.
     * @param tags Key-value map of resource tags for the container recipe.
     * @return A collection of values returned by getContainerRecipe.
     */
    public suspend fun getContainerRecipe(arn: String, tags: Map<String, String>? = null):
        GetContainerRecipeResult {
        val argument = GetContainerRecipePlainArgs(
            arn = arn,
            tags = tags,
        )
        return getContainerRecipeResultToKotlin(getContainerRecipePlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerRecipe].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetContainerRecipePlainArgs].
     * @return A collection of values returned by getContainerRecipe.
     */
    public suspend
    fun getContainerRecipe(argument: suspend GetContainerRecipePlainArgsBuilder.() -> Unit):
        GetContainerRecipeResult {
        val builder = GetContainerRecipePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerRecipeResultToKotlin(getContainerRecipePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Image Builder Container Recipes matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetContainerRecipesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getContainerRecipes(GetContainerRecipesArgs.builder()
     *             .filters(GetContainerRecipesFilterArgs.builder()
     *                 .name("platform")
     *                 .values("Linux")
     *                 .build())
     *             .owner("Self")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getContainerRecipes.
     * @return A collection of values returned by getContainerRecipes.
     */
    public suspend fun getContainerRecipes(argument: GetContainerRecipesPlainArgs):
        GetContainerRecipesResult =
        getContainerRecipesResultToKotlin(getContainerRecipesPlain(argument.toJava()).await())

    /**
     * @see [getContainerRecipes].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param owner Owner of the container recipes. Valid values are `Self`, `Shared` and `Amazon`. Defaults to `Self`.
     * @return A collection of values returned by getContainerRecipes.
     */
    public suspend fun getContainerRecipes(
        filters: List<GetContainerRecipesFilter>? = null,
        owner: String? = null,
    ): GetContainerRecipesResult {
        val argument = GetContainerRecipesPlainArgs(
            filters = filters,
            owner = owner,
        )
        return getContainerRecipesResultToKotlin(getContainerRecipesPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerRecipes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetContainerRecipesPlainArgs].
     * @return A collection of values returned by getContainerRecipes.
     */
    public suspend
    fun getContainerRecipes(argument: suspend GetContainerRecipesPlainArgsBuilder.() -> Unit):
        GetContainerRecipesResult {
        val builder = GetContainerRecipesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContainerRecipesResultToKotlin(getContainerRecipesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Image Builder Distribution Configuration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getDistributionConfiguration(GetDistributionConfigurationArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-west-2:aws:distribution-configuration/example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDistributionConfiguration.
     * @return A collection of values returned by getDistributionConfiguration.
     */
    public suspend fun getDistributionConfiguration(argument: GetDistributionConfigurationPlainArgs):
        GetDistributionConfigurationResult =
        getDistributionConfigurationResultToKotlin(getDistributionConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getDistributionConfiguration].
     * @param arn ARN of the distribution configuration.
     * @param tags Key-value map of resource tags for the distribution configuration.
     * @return A collection of values returned by getDistributionConfiguration.
     */
    public suspend fun getDistributionConfiguration(arn: String, tags: Map<String, String>? = null):
        GetDistributionConfigurationResult {
        val argument = GetDistributionConfigurationPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getDistributionConfigurationResultToKotlin(getDistributionConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDistributionConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetDistributionConfigurationPlainArgs].
     * @return A collection of values returned by getDistributionConfiguration.
     */
    public suspend
    fun getDistributionConfiguration(argument: suspend GetDistributionConfigurationPlainArgsBuilder.() -> Unit):
        GetDistributionConfigurationResult {
        val builder = GetDistributionConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDistributionConfigurationResultToKotlin(getDistributionConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Image Builder Distribution Configurations matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getDistributionConfigurations(GetDistributionConfigurationsArgs.builder()
     *             .filters(GetDistributionConfigurationsFilterArgs.builder()
     *                 .name("name")
     *                 .values("example")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDistributionConfigurations.
     * @return A collection of values returned by getDistributionConfigurations.
     */
    public suspend
    fun getDistributionConfigurations(argument: GetDistributionConfigurationsPlainArgs):
        GetDistributionConfigurationsResult =
        getDistributionConfigurationsResultToKotlin(getDistributionConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getDistributionConfigurations].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getDistributionConfigurations.
     */
    public suspend
    fun getDistributionConfigurations(filters: List<GetDistributionConfigurationsFilter>? = null):
        GetDistributionConfigurationsResult {
        val argument = GetDistributionConfigurationsPlainArgs(
            filters = filters,
        )
        return getDistributionConfigurationsResultToKotlin(getDistributionConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDistributionConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetDistributionConfigurationsPlainArgs].
     * @return A collection of values returned by getDistributionConfigurations.
     */
    public suspend
    fun getDistributionConfigurations(argument: suspend GetDistributionConfigurationsPlainArgsBuilder.() -> Unit):
        GetDistributionConfigurationsResult {
        val builder = GetDistributionConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDistributionConfigurationsResultToKotlin(getDistributionConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Image Builder Image.
     * ## Example Usage
     * ### Latest
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetImageArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getImage(GetImageArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-west-2:aws:image/amazon-linux-2-x86/x.x.x")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImage.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: GetImagePlainArgs): GetImageResult =
        getImageResultToKotlin(getImagePlain(argument.toJava()).await())

    /**
     * @see [getImage].
     * @param arn ARN of the image. The suffix can either be specified with wildcards (`x.x.x`) to fetch the latest build version or a full build version (e.g., `2020.11.26/1`) to fetch an exact version.
     * @param tags Key-value map of resource tags for the image.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(arn: String, tags: Map<String, String>? = null): GetImageResult {
        val argument = GetImagePlainArgs(
            arn = arn,
            tags = tags,
        )
        return getImageResultToKotlin(getImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetImagePlainArgs].
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: suspend GetImagePlainArgsBuilder.() -> Unit):
        GetImageResult {
        val builder = GetImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageResultToKotlin(getImagePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Image Builder Image Pipeline.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetImagePipelineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getImagePipeline(GetImagePipelineArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-west-2:aws:image-pipeline/example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImagePipeline.
     * @return A collection of values returned by getImagePipeline.
     */
    public suspend fun getImagePipeline(argument: GetImagePipelinePlainArgs): GetImagePipelineResult =
        getImagePipelineResultToKotlin(getImagePipelinePlain(argument.toJava()).await())

    /**
     * @see [getImagePipeline].
     * @param arn ARN of the image pipeline.
     * @param tags Key-value map of resource tags for the image pipeline.
     * @return A collection of values returned by getImagePipeline.
     */
    public suspend fun getImagePipeline(arn: String, tags: Map<String, String>? = null):
        GetImagePipelineResult {
        val argument = GetImagePipelinePlainArgs(
            arn = arn,
            tags = tags,
        )
        return getImagePipelineResultToKotlin(getImagePipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getImagePipeline].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetImagePipelinePlainArgs].
     * @return A collection of values returned by getImagePipeline.
     */
    public suspend
    fun getImagePipeline(argument: suspend GetImagePipelinePlainArgsBuilder.() -> Unit):
        GetImagePipelineResult {
        val builder = GetImagePipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImagePipelineResultToKotlin(getImagePipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Image Builder Image Pipelines matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetImagePipelinesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getImagePipelines(GetImagePipelinesArgs.builder()
     *             .filters(GetImagePipelinesFilterArgs.builder()
     *                 .name("name")
     *                 .values("example")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImagePipelines.
     * @return A collection of values returned by getImagePipelines.
     */
    public suspend fun getImagePipelines(argument: GetImagePipelinesPlainArgs):
        GetImagePipelinesResult =
        getImagePipelinesResultToKotlin(getImagePipelinesPlain(argument.toJava()).await())

    /**
     * @see [getImagePipelines].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getImagePipelines.
     */
    public suspend fun getImagePipelines(filters: List<GetImagePipelinesFilter>? = null):
        GetImagePipelinesResult {
        val argument = GetImagePipelinesPlainArgs(
            filters = filters,
        )
        return getImagePipelinesResultToKotlin(getImagePipelinesPlain(argument.toJava()).await())
    }

    /**
     * @see [getImagePipelines].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetImagePipelinesPlainArgs].
     * @return A collection of values returned by getImagePipelines.
     */
    public suspend
    fun getImagePipelines(argument: suspend GetImagePipelinesPlainArgsBuilder.() -> Unit):
        GetImagePipelinesResult {
        val builder = GetImagePipelinesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImagePipelinesResultToKotlin(getImagePipelinesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Image Builder Image Recipe.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetImageRecipeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getImageRecipe(GetImageRecipeArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-east-1:aws:image-recipe/example/1.0.0")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImageRecipe.
     * @return A collection of values returned by getImageRecipe.
     */
    public suspend fun getImageRecipe(argument: GetImageRecipePlainArgs): GetImageRecipeResult =
        getImageRecipeResultToKotlin(getImageRecipePlain(argument.toJava()).await())

    /**
     * @see [getImageRecipe].
     * @param arn ARN of the image recipe.
     * @param tags Key-value map of resource tags for the image recipe.
     * @return A collection of values returned by getImageRecipe.
     */
    public suspend fun getImageRecipe(arn: String, tags: Map<String, String>? = null):
        GetImageRecipeResult {
        val argument = GetImageRecipePlainArgs(
            arn = arn,
            tags = tags,
        )
        return getImageRecipeResultToKotlin(getImageRecipePlain(argument.toJava()).await())
    }

    /**
     * @see [getImageRecipe].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetImageRecipePlainArgs].
     * @return A collection of values returned by getImageRecipe.
     */
    public suspend fun getImageRecipe(argument: suspend GetImageRecipePlainArgsBuilder.() -> Unit):
        GetImageRecipeResult {
        val builder = GetImageRecipePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageRecipeResultToKotlin(getImageRecipePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Image Builder Image Recipes matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetImageRecipesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getImageRecipes(GetImageRecipesArgs.builder()
     *             .filters(GetImageRecipesFilterArgs.builder()
     *                 .name("platform")
     *                 .values("Linux")
     *                 .build())
     *             .owner("Self")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getImageRecipes.
     * @return A collection of values returned by getImageRecipes.
     */
    public suspend fun getImageRecipes(argument: GetImageRecipesPlainArgs): GetImageRecipesResult =
        getImageRecipesResultToKotlin(getImageRecipesPlain(argument.toJava()).await())

    /**
     * @see [getImageRecipes].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param owner Owner of the image recipes. Valid values are `Self`, `Shared` and `Amazon`. Defaults to `Self`.
     * @return A collection of values returned by getImageRecipes.
     */
    public suspend fun getImageRecipes(
        filters: List<GetImageRecipesFilter>? = null,
        owner: String? =
            null,
    ): GetImageRecipesResult {
        val argument = GetImageRecipesPlainArgs(
            filters = filters,
            owner = owner,
        )
        return getImageRecipesResultToKotlin(getImageRecipesPlain(argument.toJava()).await())
    }

    /**
     * @see [getImageRecipes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetImageRecipesPlainArgs].
     * @return A collection of values returned by getImageRecipes.
     */
    public suspend fun getImageRecipes(argument: suspend GetImageRecipesPlainArgsBuilder.() -> Unit):
        GetImageRecipesResult {
        val builder = GetImageRecipesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImageRecipesResultToKotlin(getImageRecipesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an Image Builder Infrastructure Configuration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getInfrastructureConfiguration(GetInfrastructureConfigurationArgs.builder()
     *             .arn("arn:aws:imagebuilder:us-west-2:aws:infrastructure-configuration/example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInfrastructureConfiguration.
     * @return A collection of values returned by getInfrastructureConfiguration.
     */
    public suspend
    fun getInfrastructureConfiguration(argument: GetInfrastructureConfigurationPlainArgs):
        GetInfrastructureConfigurationResult =
        getInfrastructureConfigurationResultToKotlin(getInfrastructureConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getInfrastructureConfiguration].
     * @param arn ARN of the infrastructure configuration.
     * @param resourceTags Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
     * @param tags Key-value map of resource tags for the infrastructure configuration.
     * @return A collection of values returned by getInfrastructureConfiguration.
     */
    public suspend fun getInfrastructureConfiguration(
        arn: String,
        resourceTags: Map<String, String>? = null,
        tags: Map<String, String>? = null,
    ): GetInfrastructureConfigurationResult {
        val argument = GetInfrastructureConfigurationPlainArgs(
            arn = arn,
            resourceTags = resourceTags,
            tags = tags,
        )
        return getInfrastructureConfigurationResultToKotlin(getInfrastructureConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getInfrastructureConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetInfrastructureConfigurationPlainArgs].
     * @return A collection of values returned by getInfrastructureConfiguration.
     */
    public suspend
    fun getInfrastructureConfiguration(argument: suspend GetInfrastructureConfigurationPlainArgsBuilder.() -> Unit):
        GetInfrastructureConfigurationResult {
        val builder = GetInfrastructureConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInfrastructureConfigurationResultToKotlin(getInfrastructureConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Image Builder Infrastructure Configurations matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.imagebuilder.ImagebuilderFunctions;
     * import com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ImagebuilderFunctions.getInfrastructureConfigurations(GetInfrastructureConfigurationsArgs.builder()
     *             .filters(GetInfrastructureConfigurationsFilterArgs.builder()
     *                 .name("name")
     *                 .values("example")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInfrastructureConfigurations.
     * @return A collection of values returned by getInfrastructureConfigurations.
     */
    public suspend
    fun getInfrastructureConfigurations(argument: GetInfrastructureConfigurationsPlainArgs):
        GetInfrastructureConfigurationsResult =
        getInfrastructureConfigurationsResultToKotlin(getInfrastructureConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getInfrastructureConfigurations].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getInfrastructureConfigurations.
     */
    public suspend
    fun getInfrastructureConfigurations(
        filters: List<GetInfrastructureConfigurationsFilter>? =
            null,
    ): GetInfrastructureConfigurationsResult {
        val argument = GetInfrastructureConfigurationsPlainArgs(
            filters = filters,
        )
        return getInfrastructureConfigurationsResultToKotlin(getInfrastructureConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInfrastructureConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;imagebuilder&#46;kotlin&#46;inputs&#46;GetInfrastructureConfigurationsPlainArgs].
     * @return A collection of values returned by getInfrastructureConfigurations.
     */
    public suspend
    fun getInfrastructureConfigurations(argument: suspend GetInfrastructureConfigurationsPlainArgsBuilder.() -> Unit):
        GetInfrastructureConfigurationsResult {
        val builder = GetInfrastructureConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInfrastructureConfigurationsResultToKotlin(getInfrastructureConfigurationsPlain(builtArgument.toJava()).await())
    }
}
