@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property componentArn Amazon Resource Name (ARN) of the Image Builder Component to associate.
 * @property parameters Configuration block(s) for parameters to configure the component. Detailed below.
 */
public data class ContainerRecipeComponentArgs(
    public val componentArn: Output<String>,
    public val parameters: Output<List<ContainerRecipeComponentParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs =
        com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentArgs.builder()
            .componentArn(componentArn.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContainerRecipeComponentArgs].
 */
@PulumiTagMarker
public class ContainerRecipeComponentArgsBuilder internal constructor() {
    private var componentArn: Output<String>? = null

    private var parameters: Output<List<ContainerRecipeComponentParameterArgs>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Component to associate.
     */
    @JvmName("umuvibiisgyvvibf")
    public suspend fun componentArn(`value`: Output<String>) {
        this.componentArn = value
    }

    /**
     * @param value Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("wwbuyvjqnrpobsfh")
    public suspend fun parameters(`value`: Output<List<ContainerRecipeComponentParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("wuanfjneefjnynet")
    public suspend fun parameters(vararg values: Output<ContainerRecipeComponentParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("eomnemnnvquxytdw")
    public suspend fun parameters(values: List<Output<ContainerRecipeComponentParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Component to associate.
     */
    @JvmName("diltntvhderrpkvy")
    public suspend fun componentArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentArn = mapped
    }

    /**
     * @param value Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("prbfqovgcdjjihod")
    public suspend fun parameters(`value`: List<ContainerRecipeComponentParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("jvehnuenkhenkxvo")
    public suspend
    fun parameters(argument: List<suspend ContainerRecipeComponentParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerRecipeComponentParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("kormnwcxxlswsbbo")
    public suspend fun parameters(
        vararg
        argument: suspend ContainerRecipeComponentParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerRecipeComponentParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("yjgtegrewchcstid")
    public suspend
    fun parameters(argument: suspend ContainerRecipeComponentParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerRecipeComponentParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("rdexrtavfxkbnkyb")
    public suspend fun parameters(vararg values: ContainerRecipeComponentParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ContainerRecipeComponentArgs = ContainerRecipeComponentArgs(
        componentArn = componentArn ?: throw PulumiNullFieldException("componentArn"),
        parameters = parameters,
    )
}
