@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the component parameter.
 * @property value The value for the named component parameter.
 */
public data class ContainerRecipeComponentParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentParameterArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentParameterArgs =
        com.pulumi.aws.imagebuilder.inputs.ContainerRecipeComponentParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRecipeComponentParameterArgs].
 */
@PulumiTagMarker
public class ContainerRecipeComponentParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the component parameter.
     */
    @JvmName("xbdxmwihbabkdaqw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value for the named component parameter.
     */
    @JvmName("tnchuxpwncjpobnp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the component parameter.
     */
    @JvmName("yebrcmgevvlyxmdb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value for the named component parameter.
     */
    @JvmName("btqtsfykqlghehuu")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ContainerRecipeComponentParameterArgs =
        ContainerRecipeComponentParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
