@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property amiTags Key-value map of tags to apply to the distributed AMI.
 * @property description Description to apply to the distributed AMI.
 * @property kmsKeyId Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
 * @property launchPermission Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
 * @property name Name to apply to the distributed AMI.
 * @property targetAccountIds Set of AWS Account identifiers to distribute the AMI.
 */
public data class DistributionConfigurationDistributionAmiDistributionConfigurationArgs(
    public val amiTags: Output<Map<String, String>>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val launchPermission:
    Output<DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs>? =
        null,
    public val name: Output<String>? = null,
    public val targetAccountIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationArgs.builder()
            .amiTags(amiTags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .launchPermission(launchPermission?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .targetAccountIds(targetAccountIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DistributionConfigurationDistributionAmiDistributionConfigurationArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationDistributionAmiDistributionConfigurationArgsBuilder internal
constructor() {
    private var amiTags: Output<Map<String, String>>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var launchPermission:
        Output<DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs>? =
        null

    private var name: Output<String>? = null

    private var targetAccountIds: Output<List<String>>? = null

    /**
     * @param value Key-value map of tags to apply to the distributed AMI.
     */
    @JvmName("ttdpnhdhqbmqnrpi")
    public suspend fun amiTags(`value`: Output<Map<String, String>>) {
        this.amiTags = value
    }

    /**
     * @param value Description to apply to the distributed AMI.
     */
    @JvmName("hedfblbkfkpjqcpx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
     */
    @JvmName("hkxgnnsxwnvwbred")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
     */
    @JvmName("qrctajkcnmayalgb")
    public suspend
    fun launchPermission(`value`: Output<DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs>) {
        this.launchPermission = value
    }

    /**
     * @param value Name to apply to the distributed AMI.
     */
    @JvmName("qiliqsmxwaultdav")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Set of AWS Account identifiers to distribute the AMI.
     */
    @JvmName("ksxteyfcerucgltj")
    public suspend fun targetAccountIds(`value`: Output<List<String>>) {
        this.targetAccountIds = value
    }

    @JvmName("fhknsifqvwdiirty")
    public suspend fun targetAccountIds(vararg values: Output<String>) {
        this.targetAccountIds = Output.all(values.asList())
    }

    /**
     * @param values Set of AWS Account identifiers to distribute the AMI.
     */
    @JvmName("aqouiexlfirfatqk")
    public suspend fun targetAccountIds(values: List<Output<String>>) {
        this.targetAccountIds = Output.all(values)
    }

    /**
     * @param value Key-value map of tags to apply to the distributed AMI.
     */
    @JvmName("xmpbvwryaktwmofh")
    public suspend fun amiTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amiTags = mapped
    }

    /**
     * @param values Key-value map of tags to apply to the distributed AMI.
     */
    @JvmName("nkcfxdccgkyqcyds")
    public fun amiTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.amiTags = mapped
    }

    /**
     * @param value Description to apply to the distributed AMI.
     */
    @JvmName("oidwcekepjgdpkdl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key to encrypt the distributed AMI.
     */
    @JvmName("csskhqtcxacfnmlo")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
     */
    @JvmName("plsprumdujfbwyuh")
    public suspend
    fun launchPermission(`value`: DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchPermission = mapped
    }

    /**
     * @param argument Configuration block of EC2 launch permissions to apply to the distributed AMI. Detailed below.
     */
    @JvmName("rgpnrndnaejsorcy")
    public suspend
    fun launchPermission(argument: suspend DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.launchPermission = mapped
    }

    /**
     * @param value Name to apply to the distributed AMI.
     */
    @JvmName("brkmnqdcjejddlxn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Set of AWS Account identifiers to distribute the AMI.
     */
    @JvmName("djdrmhekjmdauidl")
    public suspend fun targetAccountIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAccountIds = mapped
    }

    /**
     * @param values Set of AWS Account identifiers to distribute the AMI.
     */
    @JvmName("lugcawijovuxvnaw")
    public suspend fun targetAccountIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAccountIds = mapped
    }

    internal fun build(): DistributionConfigurationDistributionAmiDistributionConfigurationArgs =
        DistributionConfigurationDistributionAmiDistributionConfigurationArgs(
            amiTags = amiTags,
            description = description,
            kmsKeyId = kmsKeyId,
            launchPermission = launchPermission,
            name = name,
            targetAccountIds = targetAccountIds,
        )
}
