@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property organizationArns Set of AWS Organization ARNs to assign.
 * @property organizationalUnitArns Set of AWS Organizational Unit ARNs to assign.
 * @property userGroups Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
 * @property userIds Set of AWS Account identifiers to assign.
 */
public data class
DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs(
    public val organizationArns: Output<List<String>>? = null,
    public val organizationalUnitArns: Output<List<String>>? = null,
    public val userGroups: Output<List<String>>? = null,
    public val userIds: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs.builder()
            .organizationArns(organizationArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .organizationalUnitArns(
                organizationalUnitArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .userGroups(userGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .userIds(userIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs].
 */
@PulumiTagMarker
public class
DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgsBuilder
internal constructor() {
    private var organizationArns: Output<List<String>>? = null

    private var organizationalUnitArns: Output<List<String>>? = null

    private var userGroups: Output<List<String>>? = null

    private var userIds: Output<List<String>>? = null

    /**
     * @param value Set of AWS Organization ARNs to assign.
     */
    @JvmName("febfulntmlkbbyyg")
    public suspend fun organizationArns(`value`: Output<List<String>>) {
        this.organizationArns = value
    }

    @JvmName("grealsfytjxpivau")
    public suspend fun organizationArns(vararg values: Output<String>) {
        this.organizationArns = Output.all(values.asList())
    }

    /**
     * @param values Set of AWS Organization ARNs to assign.
     */
    @JvmName("dqmkpfjjfnlmbmal")
    public suspend fun organizationArns(values: List<Output<String>>) {
        this.organizationArns = Output.all(values)
    }

    /**
     * @param value Set of AWS Organizational Unit ARNs to assign.
     */
    @JvmName("yldslpclewhclhnq")
    public suspend fun organizationalUnitArns(`value`: Output<List<String>>) {
        this.organizationalUnitArns = value
    }

    @JvmName("pkhanxrfjliouhae")
    public suspend fun organizationalUnitArns(vararg values: Output<String>) {
        this.organizationalUnitArns = Output.all(values.asList())
    }

    /**
     * @param values Set of AWS Organizational Unit ARNs to assign.
     */
    @JvmName("flosdclwipisvqdu")
    public suspend fun organizationalUnitArns(values: List<Output<String>>) {
        this.organizationalUnitArns = Output.all(values)
    }

    /**
     * @param value Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
     */
    @JvmName("rmdiuyyhxdobyyhv")
    public suspend fun userGroups(`value`: Output<List<String>>) {
        this.userGroups = value
    }

    @JvmName("somqtjdrssxmobui")
    public suspend fun userGroups(vararg values: Output<String>) {
        this.userGroups = Output.all(values.asList())
    }

    /**
     * @param values Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
     */
    @JvmName("uhrespcuwrwpawuk")
    public suspend fun userGroups(values: List<Output<String>>) {
        this.userGroups = Output.all(values)
    }

    /**
     * @param value Set of AWS Account identifiers to assign.
     */
    @JvmName("ajpngvscywflbnvk")
    public suspend fun userIds(`value`: Output<List<String>>) {
        this.userIds = value
    }

    @JvmName("lhfljphxqpevlibu")
    public suspend fun userIds(vararg values: Output<String>) {
        this.userIds = Output.all(values.asList())
    }

    /**
     * @param values Set of AWS Account identifiers to assign.
     */
    @JvmName("ofcjxpktdqskqguc")
    public suspend fun userIds(values: List<Output<String>>) {
        this.userIds = Output.all(values)
    }

    /**
     * @param value Set of AWS Organization ARNs to assign.
     */
    @JvmName("dmuqiuvgrikslnhy")
    public suspend fun organizationArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationArns = mapped
    }

    /**
     * @param values Set of AWS Organization ARNs to assign.
     */
    @JvmName("phcyuoonylajgper")
    public suspend fun organizationArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationArns = mapped
    }

    /**
     * @param value Set of AWS Organizational Unit ARNs to assign.
     */
    @JvmName("xqippavdpwpgdqgm")
    public suspend fun organizationalUnitArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitArns = mapped
    }

    /**
     * @param values Set of AWS Organizational Unit ARNs to assign.
     */
    @JvmName("ovtindrapxdcbehy")
    public suspend fun organizationalUnitArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalUnitArns = mapped
    }

    /**
     * @param value Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
     */
    @JvmName("eiksinvhtdmpvyuy")
    public suspend fun userGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroups = mapped
    }

    /**
     * @param values Set of EC2 launch permission user groups to assign. Use `all` to distribute a public AMI.
     */
    @JvmName("swycvqbnhcemldmr")
    public suspend fun userGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userGroups = mapped
    }

    /**
     * @param value Set of AWS Account identifiers to assign.
     */
    @JvmName("iuneeitfsbmgdawd")
    public suspend fun userIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param values Set of AWS Account identifiers to assign.
     */
    @JvmName("ljrnyvbfskufgves")
    public suspend fun userIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    internal fun build():
        DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs =
        DistributionConfigurationDistributionAmiDistributionConfigurationLaunchPermissionArgs(
            organizationArns = organizationArns,
            organizationalUnitArns = organizationalUnitArns,
            userGroups = userGroups,
            userIds = userIds,
        )
}
