@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionLaunchTemplateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountId The account ID that this configuration applies to.
 * @property default Indicates whether to set the specified Amazon EC2 launch template as the default launch template. Defaults to `true`.
 * @property launchTemplateId The ID of the Amazon EC2 launch template to use.
 */
public data class DistributionConfigurationDistributionLaunchTemplateConfigurationArgs(
    public val accountId: Output<String>? = null,
    public val default: Output<Boolean>? = null,
    public val launchTemplateId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionLaunchTemplateConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionLaunchTemplateConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionLaunchTemplateConfigurationArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .default_(default?.applyValue({ args0 -> args0 }))
            .launchTemplateId(launchTemplateId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionConfigurationDistributionLaunchTemplateConfigurationArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder internal
constructor() {
    private var accountId: Output<String>? = null

    private var default: Output<Boolean>? = null

    private var launchTemplateId: Output<String>? = null

    /**
     * @param value The account ID that this configuration applies to.
     */
    @JvmName("ygrlybppmlpxighc")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Indicates whether to set the specified Amazon EC2 launch template as the default launch template. Defaults to `true`.
     */
    @JvmName("pykpsfeuislxgtyi")
    public suspend fun default(`value`: Output<Boolean>) {
        this.default = value
    }

    /**
     * @param value The ID of the Amazon EC2 launch template to use.
     */
    @JvmName("nfkcwgeoawfaokoc")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The account ID that this configuration applies to.
     */
    @JvmName("myxfdjgiweheyand")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Indicates whether to set the specified Amazon EC2 launch template as the default launch template. Defaults to `true`.
     */
    @JvmName("kreofejfpbyomdsh")
    public suspend fun default(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.default = mapped
    }

    /**
     * @param value The ID of the Amazon EC2 launch template to use.
     */
    @JvmName("qomkxmnqofmdaecl")
    public suspend fun launchTemplateId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    internal fun build(): DistributionConfigurationDistributionLaunchTemplateConfigurationArgs =
        DistributionConfigurationDistributionLaunchTemplateConfigurationArgs(
            accountId = accountId,
            default = default,
            launchTemplateId = launchTemplateId ?: throw PulumiNullFieldException("launchTemplateId"),
        )
}
