@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetComponentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getComponents.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property owner Owner of the image recipes. Valid values are `Self`, `Shared` and `Amazon`. Defaults to `Self`.
 */
public data class GetComponentsPlainArgs(
    public val filters: List<GetComponentsFilter>? = null,
    public val owner: String? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetComponentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetComponentsPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetComponentsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .owner(owner?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetComponentsPlainArgs].
 */
@PulumiTagMarker
public class GetComponentsPlainArgsBuilder internal constructor() {
    private var filters: List<GetComponentsFilter>? = null

    private var owner: String? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ymowgxqsiwsvrlan")
    public suspend fun filters(`value`: List<GetComponentsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("kgisywluslyrojbv")
    public suspend fun filters(argument: List<suspend GetComponentsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetComponentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("plgkhggbstucofcv")
    public suspend fun filters(vararg argument: suspend GetComponentsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetComponentsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jvbesqejsyrosktv")
    public suspend fun filters(argument: suspend GetComponentsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetComponentsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("xlcgrkunytscsasg")
    public suspend fun filters(vararg values: GetComponentsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Owner of the image recipes. Valid values are `Self`, `Shared` and `Amazon`. Defaults to `Self`.
     */
    @JvmName("egtuhvpeciqiicea")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owner = mapped
    }

    internal fun build(): GetComponentsPlainArgs = GetComponentsPlainArgs(
        filters = filters,
        owner = owner,
    )
}
