@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetContainerRecipePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContainerRecipe.
 * @property arn ARN of the container recipe.
 * @property tags Key-value map of resource tags for the container recipe.
 */
public data class GetContainerRecipePlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetContainerRecipePlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetContainerRecipePlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetContainerRecipePlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetContainerRecipePlainArgs].
 */
@PulumiTagMarker
public class GetContainerRecipePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the container recipe.
     */
    @JvmName("snbmlkhmthvrythm")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Key-value map of resource tags for the container recipe.
     */
    @JvmName("hgxbgylakuehmpxf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the container recipe.
     */
    @JvmName("kxwwnpqsiswdnkhs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetContainerRecipePlainArgs = GetContainerRecipePlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
