@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDistributionConfiguration.
 * @property arn ARN of the distribution configuration.
 * @property tags Key-value map of resource tags for the distribution configuration.
 */
public data class GetDistributionConfigurationPlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDistributionConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetDistributionConfigurationPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the distribution configuration.
     */
    @JvmName("xlovqfjulwfxkven")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Key-value map of resource tags for the distribution configuration.
     */
    @JvmName("umhextqyskggxagx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the distribution configuration.
     */
    @JvmName("eywpwniixhajsghl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDistributionConfigurationPlainArgs =
        GetDistributionConfigurationPlainArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            tags = tags,
        )
}
