@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDistributionConfigurations.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetDistributionConfigurationsPlainArgs(
    public val filters: List<GetDistributionConfigurationsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationsPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationsPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetDistributionConfigurationsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetDistributionConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class GetDistributionConfigurationsPlainArgsBuilder internal constructor() {
    private var filters: List<GetDistributionConfigurationsFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("eoxmlubllciaxxdv")
    public suspend fun filters(`value`: List<GetDistributionConfigurationsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("gyppphbuknbeinjc")
    public suspend
    fun filters(argument: List<suspend GetDistributionConfigurationsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetDistributionConfigurationsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("fxrignmaxnixqynn")
    public suspend fun filters(
        vararg
        argument: suspend GetDistributionConfigurationsFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetDistributionConfigurationsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jxnagsckupkrfywq")
    public suspend
    fun filters(argument: suspend GetDistributionConfigurationsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetDistributionConfigurationsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("rphvoqfrnoffyxum")
    public suspend fun filters(vararg values: GetDistributionConfigurationsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetDistributionConfigurationsPlainArgs =
        GetDistributionConfigurationsPlainArgs(
            filters = filters,
        )
}
