@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetImagePipelinesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImagePipelines.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetImagePipelinesPlainArgs(
    public val filters: List<GetImagePipelinesFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetImagePipelinesPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetImagePipelinesPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetImagePipelinesPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetImagePipelinesPlainArgs].
 */
@PulumiTagMarker
public class GetImagePipelinesPlainArgsBuilder internal constructor() {
    private var filters: List<GetImagePipelinesFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("fusalrepfplxgabs")
    public suspend fun filters(`value`: List<GetImagePipelinesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ipxfoyiqcsebyynm")
    public suspend fun filters(argument: List<suspend GetImagePipelinesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetImagePipelinesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("fjcabetgsglqamjq")
    public suspend fun filters(vararg argument: suspend GetImagePipelinesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetImagePipelinesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("qsrkdbbipeycfbsk")
    public suspend fun filters(argument: suspend GetImagePipelinesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetImagePipelinesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("yhruqpwxtkgjlbtr")
    public suspend fun filters(vararg values: GetImagePipelinesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetImagePipelinesPlainArgs = GetImagePipelinesPlainArgs(
        filters = filters,
    )
}
