@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInfrastructureConfigurations.
 * @property filters Configuration block(s) for filtering. Detailed below.
 */
public data class GetInfrastructureConfigurationsPlainArgs(
    public val filters: List<GetInfrastructureConfigurationsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationsPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationsPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetInfrastructureConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class GetInfrastructureConfigurationsPlainArgsBuilder internal constructor() {
    private var filters: List<GetInfrastructureConfigurationsFilter>? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("gyiveabosoejkrea")
    public suspend fun filters(`value`: List<GetInfrastructureConfigurationsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("mrdixskbjctrpodt")
    public suspend
    fun filters(argument: List<suspend GetInfrastructureConfigurationsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInfrastructureConfigurationsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("ykjxffqxuvgmdxfv")
    public suspend fun filters(
        vararg
        argument: suspend GetInfrastructureConfigurationsFilterBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GetInfrastructureConfigurationsFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("igjojpfujbvjadra")
    public suspend
    fun filters(argument: suspend GetInfrastructureConfigurationsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetInfrastructureConfigurationsFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("iphpmnltdloqtalu")
    public suspend fun filters(vararg values: GetInfrastructureConfigurationsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetInfrastructureConfigurationsPlainArgs =
        GetInfrastructureConfigurationsPlainArgs(
            filters = filters,
        )
}
