@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationEcrConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerTags Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
 * @property repositoryName The name of the container repository that Amazon Inspector scans to identify findings for your container images.
 */
public data class ImageImageScanningConfigurationEcrConfigurationArgs(
    public val containerTags: Output<List<String>>? = null,
    public val repositoryName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationEcrConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationEcrConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationEcrConfigurationArgs.builder()
            .containerTags(containerTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageImageScanningConfigurationEcrConfigurationArgs].
 */
@PulumiTagMarker
public class ImageImageScanningConfigurationEcrConfigurationArgsBuilder internal constructor() {
    private var containerTags: Output<List<String>>? = null

    private var repositoryName: Output<String>? = null

    /**
     * @param value Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
     */
    @JvmName("xbithbtqewwdtmly")
    public suspend fun containerTags(`value`: Output<List<String>>) {
        this.containerTags = value
    }

    @JvmName("ujhprtvqvkqyyiia")
    public suspend fun containerTags(vararg values: Output<String>) {
        this.containerTags = Output.all(values.asList())
    }

    /**
     * @param values Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
     */
    @JvmName("ijvouxmoesweaiwq")
    public suspend fun containerTags(values: List<Output<String>>) {
        this.containerTags = Output.all(values)
    }

    /**
     * @param value The name of the container repository that Amazon Inspector scans to identify findings for your container images.
     */
    @JvmName("nsmmmagxrebrcinf")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
     */
    @JvmName("gaerycqcbxlybnuo")
    public suspend fun containerTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerTags = mapped
    }

    /**
     * @param values Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
     */
    @JvmName("nslaruceoprpuddx")
    public suspend fun containerTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerTags = mapped
    }

    /**
     * @param value The name of the container repository that Amazon Inspector scans to identify findings for your container images.
     */
    @JvmName("baosyxiucotjuyso")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    internal fun build(): ImageImageScanningConfigurationEcrConfigurationArgs =
        ImageImageScanningConfigurationEcrConfigurationArgs(
            containerTags = containerTags,
            repositoryName = repositoryName,
        )
}
