@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ecrConfiguration Configuration block with ECR configuration for image scanning. Detailed below.
 * @property imageScanningEnabled Whether image scans are enabled. Defaults to `false`.
 */
public data class ImagePipelineImageScanningConfigurationArgs(
    public val ecrConfiguration: Output<ImagePipelineImageScanningConfigurationEcrConfigurationArgs>? =
        null,
    public val imageScanningEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationArgs.builder()
            .ecrConfiguration(ecrConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageScanningEnabled(imageScanningEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePipelineImageScanningConfigurationArgs].
 */
@PulumiTagMarker
public class ImagePipelineImageScanningConfigurationArgsBuilder internal constructor() {
    private var ecrConfiguration: Output<ImagePipelineImageScanningConfigurationEcrConfigurationArgs>? =
        null

    private var imageScanningEnabled: Output<Boolean>? = null

    /**
     * @param value Configuration block with ECR configuration for image scanning. Detailed below.
     */
    @JvmName("shghavufrepaaoly")
    public suspend
    fun ecrConfiguration(`value`: Output<ImagePipelineImageScanningConfigurationEcrConfigurationArgs>) {
        this.ecrConfiguration = value
    }

    /**
     * @param value Whether image scans are enabled. Defaults to `false`.
     */
    @JvmName("dedxyuqgiewigdln")
    public suspend fun imageScanningEnabled(`value`: Output<Boolean>) {
        this.imageScanningEnabled = value
    }

    /**
     * @param value Configuration block with ECR configuration for image scanning. Detailed below.
     */
    @JvmName("embdernlleaismqs")
    public suspend
    fun ecrConfiguration(`value`: ImagePipelineImageScanningConfigurationEcrConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrConfiguration = mapped
    }

    /**
     * @param argument Configuration block with ECR configuration for image scanning. Detailed below.
     */
    @JvmName("dxmlbjqnhhfhjjtv")
    public suspend
    fun ecrConfiguration(argument: suspend ImagePipelineImageScanningConfigurationEcrConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ImagePipelineImageScanningConfigurationEcrConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ecrConfiguration = mapped
    }

    /**
     * @param value Whether image scans are enabled. Defaults to `false`.
     */
    @JvmName("gjdhwqfknqaaxxsh")
    public suspend fun imageScanningEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningEnabled = mapped
    }

    internal fun build(): ImagePipelineImageScanningConfigurationArgs =
        ImagePipelineImageScanningConfigurationArgs(
            ecrConfiguration = ecrConfiguration,
            imageScanningEnabled = imageScanningEnabled,
        )
}
