@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageTestsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageTestsEnabled Whether image tests are enabled. Defaults to `true`.
 * @property timeoutMinutes Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
 */
public data class ImagePipelineImageTestsConfigurationArgs(
    public val imageTestsEnabled: Output<Boolean>? = null,
    public val timeoutMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageTestsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageTestsConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageTestsConfigurationArgs.builder()
            .imageTestsEnabled(imageTestsEnabled?.applyValue({ args0 -> args0 }))
            .timeoutMinutes(timeoutMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePipelineImageTestsConfigurationArgs].
 */
@PulumiTagMarker
public class ImagePipelineImageTestsConfigurationArgsBuilder internal constructor() {
    private var imageTestsEnabled: Output<Boolean>? = null

    private var timeoutMinutes: Output<Int>? = null

    /**
     * @param value Whether image tests are enabled. Defaults to `true`.
     */
    @JvmName("viiwvdjvxrjmgqyl")
    public suspend fun imageTestsEnabled(`value`: Output<Boolean>) {
        this.imageTestsEnabled = value
    }

    /**
     * @param value Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
     */
    @JvmName("nksrvlbnhipqpacf")
    public suspend fun timeoutMinutes(`value`: Output<Int>) {
        this.timeoutMinutes = value
    }

    /**
     * @param value Whether image tests are enabled. Defaults to `true`.
     */
    @JvmName("ejathijcwwnsqyxx")
    public suspend fun imageTestsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTestsEnabled = mapped
    }

    /**
     * @param value Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
     */
    @JvmName("lwuxfetiixthbqkk")
    public suspend fun timeoutMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutMinutes = mapped
    }

    internal fun build(): ImagePipelineImageTestsConfigurationArgs =
        ImagePipelineImageTestsConfigurationArgs(
            imageTestsEnabled = imageTestsEnabled,
            timeoutMinutes = timeoutMinutes,
        )
}
