@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageRecipeBlockDeviceMappingEbsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deleteOnTermination Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
 * @property encrypted Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
 * @property iops Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
 * @property kmsKeyId Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
 * @property snapshotId Identifier of the EC2 Volume Snapshot.
 * @property throughput For GP3 volumes only. The throughput in MiB/s that the volume supports.
 * @property volumeSize Size of the volume, in GiB.
 * @property volumeType Type of the volume. For example, `gp2` or `io2`.
 */
public data class ImageRecipeBlockDeviceMappingEbsArgs(
    public val deleteOnTermination: Output<String>? = null,
    public val encrypted: Output<String>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val throughput: Output<Int>? = null,
    public val volumeSize: Output<Int>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageRecipeBlockDeviceMappingEbsArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageRecipeBlockDeviceMappingEbsArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageRecipeBlockDeviceMappingEbsArgs.builder()
            .deleteOnTermination(deleteOnTermination?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .iops(iops?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .throughput(throughput?.applyValue({ args0 -> args0 }))
            .volumeSize(volumeSize?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRecipeBlockDeviceMappingEbsArgs].
 */
@PulumiTagMarker
public class ImageRecipeBlockDeviceMappingEbsArgsBuilder internal constructor() {
    private var deleteOnTermination: Output<String>? = null

    private var encrypted: Output<String>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var throughput: Output<Int>? = null

    private var volumeSize: Output<Int>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
     */
    @JvmName("nvdeueumfogalfvj")
    public suspend fun deleteOnTermination(`value`: Output<String>) {
        this.deleteOnTermination = value
    }

    /**
     * @param value Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
     */
    @JvmName("giuubofxoxxmllyr")
    public suspend fun encrypted(`value`: Output<String>) {
        this.encrypted = value
    }

    /**
     * @param value Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
     */
    @JvmName("ldceohufxgqoacbn")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
     */
    @JvmName("ehxcfntkiuvqqeer")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Identifier of the EC2 Volume Snapshot.
     */
    @JvmName("capaklnalpddbque")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value For GP3 volumes only. The throughput in MiB/s that the volume supports.
     */
    @JvmName("bhjcfhbvnxiywvuv")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value Size of the volume, in GiB.
     */
    @JvmName("yhkygutaxrelljpg")
    public suspend fun volumeSize(`value`: Output<Int>) {
        this.volumeSize = value
    }

    /**
     * @param value Type of the volume. For example, `gp2` or `io2`.
     */
    @JvmName("noeubascyulopyfw")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
     */
    @JvmName("iovdllnjrirswcpw")
    public suspend fun deleteOnTermination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOnTermination = mapped
    }

    /**
     * @param value Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
     */
    @JvmName("vliwkfirkysogygf")
    public suspend fun encrypted(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
     */
    @JvmName("ldxjcvhcmtaqwsox")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
     */
    @JvmName("rpvkekijqcburgpc")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Identifier of the EC2 Volume Snapshot.
     */
    @JvmName("jcpwfgxpdlqxlwpa")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value For GP3 volumes only. The throughput in MiB/s that the volume supports.
     */
    @JvmName("godsycavwklluxin")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value Size of the volume, in GiB.
     */
    @JvmName("kubqnfqlvwkrxoqe")
    public suspend fun volumeSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSize = mapped
    }

    /**
     * @param value Type of the volume. For example, `gp2` or `io2`.
     */
    @JvmName("mquctjfarjanmrip")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): ImageRecipeBlockDeviceMappingEbsArgs = ImageRecipeBlockDeviceMappingEbsArgs(
        deleteOnTermination = deleteOnTermination,
        encrypted = encrypted,
        iops = iops,
        kmsKeyId = kmsKeyId,
        snapshotId = snapshotId,
        throughput = throughput,
        volumeSize = volumeSize,
        volumeType = volumeType,
    )
}
