@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationInstanceMetadataOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property httpPutResponseHopLimit The number of hops that an instance can traverse to reach its destonation.
 * @property httpTokens Whether a signed token is required for instance metadata retrieval requests. Valid values: `required`, `optional`.
 */
public data class InfrastructureConfigurationInstanceMetadataOptionsArgs(
    public val httpPutResponseHopLimit: Output<Int>? = null,
    public val httpTokens: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationInstanceMetadataOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationInstanceMetadataOptionsArgs =
        com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationInstanceMetadataOptionsArgs.builder()
            .httpPutResponseHopLimit(httpPutResponseHopLimit?.applyValue({ args0 -> args0 }))
            .httpTokens(httpTokens?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureConfigurationInstanceMetadataOptionsArgs].
 */
@PulumiTagMarker
public class InfrastructureConfigurationInstanceMetadataOptionsArgsBuilder internal constructor() {
    private var httpPutResponseHopLimit: Output<Int>? = null

    private var httpTokens: Output<String>? = null

    /**
     * @param value The number of hops that an instance can traverse to reach its destonation.
     */
    @JvmName("qumskhmjklicckuc")
    public suspend fun httpPutResponseHopLimit(`value`: Output<Int>) {
        this.httpPutResponseHopLimit = value
    }

    /**
     * @param value Whether a signed token is required for instance metadata retrieval requests. Valid values: `required`, `optional`.
     */
    @JvmName("scjftgorhpluxulm")
    public suspend fun httpTokens(`value`: Output<String>) {
        this.httpTokens = value
    }

    /**
     * @param value The number of hops that an instance can traverse to reach its destonation.
     */
    @JvmName("rjcidextrepdrqyk")
    public suspend fun httpPutResponseHopLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPutResponseHopLimit = mapped
    }

    /**
     * @param value Whether a signed token is required for instance metadata retrieval requests. Valid values: `required`, `optional`.
     */
    @JvmName("iaaxijpeyjabgqfv")
    public suspend fun httpTokens(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpTokens = mapped
    }

    internal fun build(): InfrastructureConfigurationInstanceMetadataOptionsArgs =
        InfrastructureConfigurationInstanceMetadataOptionsArgs(
            httpPutResponseHopLimit = httpPutResponseHopLimit,
            httpTokens = httpTokens,
        )
}
