@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Logs Configuration block with S3 logging settings. Detailed below.
 */
public data class InfrastructureConfigurationLoggingArgs(
    public val s3Logs: Output<InfrastructureConfigurationLoggingS3LogsArgs>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingArgs =
        com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingArgs.builder()
            .s3Logs(s3Logs.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InfrastructureConfigurationLoggingArgs].
 */
@PulumiTagMarker
public class InfrastructureConfigurationLoggingArgsBuilder internal constructor() {
    private var s3Logs: Output<InfrastructureConfigurationLoggingS3LogsArgs>? = null

    /**
     * @param value Configuration block with S3 logging settings. Detailed below.
     */
    @JvmName("rvgjgyhcvaofqjsg")
    public suspend fun s3Logs(`value`: Output<InfrastructureConfigurationLoggingS3LogsArgs>) {
        this.s3Logs = value
    }

    /**
     * @param value Configuration block with S3 logging settings. Detailed below.
     */
    @JvmName("lkawympayefblpvb")
    public suspend fun s3Logs(`value`: InfrastructureConfigurationLoggingS3LogsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Logs = mapped
    }

    /**
     * @param argument Configuration block with S3 logging settings. Detailed below.
     */
    @JvmName("pynuyhxnkwfughmj")
    public suspend
    fun s3Logs(argument: suspend InfrastructureConfigurationLoggingS3LogsArgsBuilder.() -> Unit) {
        val toBeMapped = InfrastructureConfigurationLoggingS3LogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Logs = mapped
    }

    internal fun build(): InfrastructureConfigurationLoggingArgs =
        InfrastructureConfigurationLoggingArgs(
            s3Logs = s3Logs ?: throw PulumiNullFieldException("s3Logs"),
        )
}
